/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.bitmap;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import org.krysalis.barcode4j.output.bitmap.ImageIOBitmapEncoder;

public class BitmapEncoderRegistry {
    private static final Logger log = Logger.getLogger(BitmapEncoderRegistry.class.getName());
    private static final Set<Entry> encoders = new TreeSet<Entry>();

    protected BitmapEncoderRegistry() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private static synchronized void register(String classname, int priority, boolean complain) {
        boolean failed = false;
        try {
            Class<?> clazz = Class.forName(classname);
            BitmapEncoder encoder = (BitmapEncoder)clazz.newInstance();
            BitmapEncoderRegistry.register(encoder, priority);
        }
        catch (Exception e) {
            log.warning("Failed to create BitmapEncoder of class " + classname + ": " + e.getMessage());
            failed = true;
        }
        catch (LinkageError e) {
            log.warning("Failed to create BitmapEncoder of class " + classname + ": " + e.getMessage());
            failed = true;
        }
        if (failed && complain) {
            String msg = "The implementation being registered is unavailable or cannot be instantiated: " + classname;
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public static synchronized <T extends BitmapEncoder> boolean register(T bitmapEncoder, int priority) {
        return encoders.add(new Entry(bitmapEncoder, priority));
    }

    @Deprecated
    public static void register(String classname, int priority) {
        BitmapEncoderRegistry.register(classname, priority, true);
    }

    public static <BitmapEncoder> void register(Class<BitmapEncoder> bitmapEncoderClass, int priority) {
        BitmapEncoderRegistry.register(bitmapEncoderClass, priority, true);
    }

    private static <BitmapEncoder> void register(Class<BitmapEncoder> bitmapEncoderClass, int priority, boolean complain) {
        BitmapEncoderRegistry.register(bitmapEncoderClass.getName(), priority, complain);
    }

    public static boolean supports(BitmapEncoder encoder, String mimeType) {
        String[] mimes;
        for (String s : mimes = encoder.getSupportedMIMETypes()) {
            if (!s.equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    public static boolean supports(String mimeType) {
        for (Entry encoder : encoders) {
            if (!BitmapEncoderRegistry.supports(encoder.encoder, mimeType)) continue;
            return true;
        }
        return false;
    }

    public static BitmapEncoder getInstance(String mimeType) {
        for (Entry entry : encoders) {
            BitmapEncoder encoder = entry.encoder;
            if (!BitmapEncoderRegistry.supports(encoder, mimeType)) continue;
            return encoder;
        }
        throw new UnsupportedOperationException("No BitmapEncoder available for " + mimeType);
    }

    public static Set<String> getSupportedMIMETypes() {
        HashSet<String> mimes = new HashSet<String>();
        for (Entry entry : encoders) {
            Collections.addAll(mimes, entry.encoder.getSupportedMIMETypes());
        }
        return mimes;
    }

    static {
        BitmapEncoderRegistry.register(new ImageIOBitmapEncoder(), 0);
    }

    private static class Entry
    implements Comparable<Entry> {
        private final BitmapEncoder encoder;
        private final int priority;

        public Entry(BitmapEncoder encoder, int priority) {
            this.encoder = encoder;
            this.priority = priority;
        }

        @Override
        public int compareTo(Entry other) {
            return other.priority - this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.priority == entry.priority && Objects.equals(this.encoder, entry.encoder);
        }

        public int hashCode() {
            return Objects.hash(this.encoder, this.priority);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Entry{");
            sb.append("encoder=").append(this.encoder);
            sb.append(", priority=").append(this.priority);
            sb.append('}');
            return sb.toString();
        }
    }
}

