/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.bitmap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import org.krysalis.barcode4j.tools.DebugUtil;
import org.krysalis.barcode4j.tools.UnitConv;

public class ImageIOBitmapEncoder
implements BitmapEncoder {
    private static final Logger log = Logger.getLogger(ImageIOBitmapEncoder.class.getName());

    @Override
    public String[] getSupportedMIMETypes() {
        return ImageIO.getWriterMIMETypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(BufferedImage image, OutputStream out, String mime, int resolution) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByMIMEType(mime).next();
        ImageOutputStream imOutput = ImageIO.createImageOutputStream(out);
        if (writer != null && imOutput != null) {
            try {
                writer.setOutput(imOutput);
                IIOMetadata iioMeta = this.setupMetadata(image, writer, mime, resolution);
                IIOImage iioImage = new IIOImage(image, null, iioMeta);
                writer.write(iioImage);
            }
            catch (IllegalStateException e) {
                log.severe(e.getMessage());
            }
            finally {
                writer.dispose();
                imOutput.close();
            }
        } else {
            String msg = MessageFormat.format("ImageWriter: {0}, ImageOutputStream: {1}", writer, imOutput);
            log.severe(msg);
            throw new RuntimeException(msg);
        }
    }

    private IIOMetadata setupMetadata(BufferedImage image, ImageWriter writer, String mime, int resolution) throws IOException {
        IIOMetadata iiometa;
        try {
            iiometa = writer.getDefaultImageMetadata(new ImageTypeSpecifier(image), writer.getDefaultWriteParam());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
        if (iiometa == null) {
            return null;
        }
        String stdmeta = "javax_imageio_1.0";
        String jpegmeta = "javax_imageio_jpeg_image_1.0";
        if (!iiometa.isReadOnly()) {
            if ("image/jpeg".equals(mime) && "javax_imageio_jpeg_image_1.0".equals(iiometa.getNativeMetadataFormatName())) {
                this.checkWritable(iiometa);
                IIOMetadataNode rootnode = (IIOMetadataNode)iiometa.getAsTree("javax_imageio_jpeg_image_1.0");
                IIOMetadataNode variety = (IIOMetadataNode)rootnode.getElementsByTagName("JPEGvariety").item(0);
                IIOMetadataNode jfif = (IIOMetadataNode)variety.getElementsByTagName("app0JFIF").item(0);
                jfif.setAttribute("resUnits", "1");
                jfif.setAttribute("Xdensity", Integer.toString(resolution));
                jfif.setAttribute("Ydensity", Integer.toString(resolution));
                iiometa.setFromTree("javax_imageio_jpeg_image_1.0", rootnode);
            } else if (iiometa.isStandardMetadataFormatSupported()) {
                this.checkWritable(iiometa);
                IIOMetadataNode rootnode = new IIOMetadataNode("javax_imageio_1.0");
                IIOMetadataNode imagedim = new IIOMetadataNode("Dimension");
                IIOMetadataNode child = new IIOMetadataNode("HorizontalPixelSize");
                double effResolution = 1.0 / (UnitConv.in2mm(1.0) / (double)resolution);
                child.setAttribute("value", Double.toString(effResolution));
                imagedim.appendChild(child);
                child = new IIOMetadataNode("VerticalPixelSize");
                child.setAttribute("value", Double.toString(effResolution));
                imagedim.appendChild(child);
                IIOMetadataNode textNode = new IIOMetadataNode("Text");
                child = new IIOMetadataNode("TextEntry");
                child.setAttribute("keyword", "Software");
                child.setAttribute("value", "Barcode4J");
                child.setAttribute("encoding", "Unicode");
                child.setAttribute("language", "en");
                child.setAttribute("compression", "none");
                textNode.appendChild(child);
                rootnode.appendChild(imagedim);
                rootnode.appendChild(textNode);
                try {
                    iiometa.mergeTree("javax_imageio_1.0", rootnode);
                }
                catch (Exception e1) {
                    try {
                        iiometa.setFromTree("javax_imageio_1.0", rootnode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return iiometa;
    }

    private void checkWritable(IIOMetadata iiometa) throws IOException {
        if (iiometa.isReadOnly()) {
            throw new IOException("Metadata is read-only. Cannot modify");
        }
    }

    private void dumpMetadata(IIOMetadata iiometa) {
        String[] metanames = iiometa.getMetadataFormatNames();
        for (int j = 0; j < metanames.length; ++j) {
            System.out.println("--->" + metanames[j]);
            DebugUtil.dumpNode(iiometa.getAsTree(metanames[j]));
        }
    }
}

