/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;

public class BarcodeComponent
extends JComponent {
    private BarcodeGenerator bargen;
    private String msg;
    private Java2DCanvasProvider canvas;
    private BarcodeDimension bardim;
    private int orientation;

    public BarcodeComponent(BarcodeGenerator generator, String msg) {
        this(generator, msg, 0);
    }

    public BarcodeComponent(BarcodeGenerator generator, String msg, int orientation) {
        this.bargen = generator;
        this.msg = msg;
        this.orientation = orientation;
        this.updateBarcodeDimension();
        this.repaint();
    }

    protected void updateBarcodeDimension() {
        if (this.getBarcodeGenerator() != null && this.getMessage() != null) {
            try {
                this.bardim = this.getBarcodeGenerator().calcDimensions(this.getMessage());
            }
            catch (IllegalArgumentException iae) {
                this.bardim = null;
            }
        } else {
            this.bardim = null;
        }
    }

    public void setBarcodeGenerator(BarcodeGenerator generator) {
        this.bargen = generator;
        this.updateBarcodeDimension();
        this.repaint();
    }

    public BarcodeGenerator getBarcodeGenerator() {
        return this.bargen;
    }

    public void setMessage(String msg) {
        if (!msg.equals(this.msg)) {
            this.msg = msg;
            this.updateBarcodeDimension();
            this.repaint();
        }
    }

    public String getMessage() {
        return this.msg;
    }

    public BarcodeDimension getBarcodeDimension() {
        return this.bardim;
    }

    private void transformAsNecessary(Graphics2D g2d) {
        if (this.getBarcodeDimension() != null) {
            double scale;
            double horzScale = (double)this.getWidth() / this.getBarcodeDimension().getWidthPlusQuiet();
            double vertScale = (double)this.getHeight() / this.getBarcodeDimension().getHeightPlusQuiet();
            double dx = 0.0;
            double dy = 0.0;
            if (horzScale < vertScale) {
                scale = horzScale;
                dy = ((double)this.getHeight() / scale - this.getBarcodeDimension().getHeightPlusQuiet()) / 2.0;
            } else {
                scale = vertScale;
                dx = ((double)this.getWidth() / scale - this.getBarcodeDimension().getWidthPlusQuiet()) / 2.0;
            }
            g2d.scale(scale, scale);
            g2d.translate(dx, dy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (this.bargen == null || this.msg == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.canvas == null) {
            this.canvas = new Java2DCanvasProvider(g2d, this.orientation);
        } else {
            this.canvas.setGraphics2D(g2d);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        try {
            AffineTransform baktrans = g2d.getTransform();
            try {
                this.transformAsNecessary(g2d);
                g2d.setColor(Color.black);
                this.getBarcodeGenerator().generateBarcode(this.canvas, this.getMessage());
            }
            finally {
                g2d.setTransform(baktrans);
            }
        }
        catch (Exception e) {
            g.setColor(Color.red);
            g.drawLine(0, 0, this.getWidth(), this.getHeight());
            g.drawLine(0, this.getHeight(), this.getWidth(), 0);
        }
    }
}

