/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

import java.util.HashMap;
import java.util.Map;

public class ECIUtil {
    public static final int ECI_BINARY = 899;
    private static final Map encodingToECI = new HashMap();

    private static void mapEncoding(String encoding, int eci) {
        encodingToECI.put(encoding, new Integer(eci));
    }

    public static int getECIForEncoding(String encoding) {
        Integer code = (Integer)encodingToECI.get(encoding);
        if (code != null) {
            return code;
        }
        return -1;
    }

    static {
        ECIUtil.mapEncoding("Cp437", 2);
        ECIUtil.mapEncoding("ISO-8859-1", 3);
        ECIUtil.mapEncoding("ISO-8859-2", 4);
        ECIUtil.mapEncoding("ISO-8859-3", 5);
        ECIUtil.mapEncoding("ISO-8859-4", 6);
        ECIUtil.mapEncoding("ISO-8859-5", 7);
        ECIUtil.mapEncoding("ISO-8859-6", 8);
        ECIUtil.mapEncoding("ISO-8859-7", 9);
        ECIUtil.mapEncoding("ISO-8859-8", 10);
        ECIUtil.mapEncoding("ISO-8859-9", 11);
        ECIUtil.mapEncoding("ISO-8859-10", 12);
        ECIUtil.mapEncoding("ISO-8859-11", 13);
        ECIUtil.mapEncoding("ISO-8859-13", 15);
        ECIUtil.mapEncoding("ISO-8859-14", 16);
        ECIUtil.mapEncoding("ISO-8859-15", 17);
        ECIUtil.mapEncoding("ISO-8859-16", 18);
        ECIUtil.mapEncoding("SJIS", 20);
        ECIUtil.mapEncoding("Cp1250", 21);
        ECIUtil.mapEncoding("Cp1251", 22);
        ECIUtil.mapEncoding("Cp1252", 23);
        ECIUtil.mapEncoding("Cp1256", 24);
        ECIUtil.mapEncoding("UnicodeBigUnmarked", 25);
        ECIUtil.mapEncoding("UTF-8", 26);
        ECIUtil.mapEncoding("US-ASCII", 27);
        ECIUtil.mapEncoding("Big5", 28);
        ECIUtil.mapEncoding("GB18030", 29);
    }
}

