/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.Driver;
import com.singlestore.jdbc.MariaDbPoolConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class MariaDbDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource {
    private final Configuration conf;

    public MariaDbDataSource(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong SingleStoreDB url: %s", url));
        }
        this.conf = Configuration.parse(url);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return Driver.connect(this.conf);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Configuration conf = this.conf.clone(username, password);
        return Driver.connect(conf);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("Datasource is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        return this.conf.connectTimeout() / 1000;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.conf.connectTimeout(seconds * 1000);
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new MariaDbPoolConnection(Driver.connect(this.conf));
    }

    @Override
    public PooledConnection getPooledConnection(String username, String password) throws SQLException {
        Configuration conf = this.conf.clone(username, password);
        return new MariaDbPoolConnection(Driver.connect(conf));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new MariaDbPoolConnection(Driver.connect(this.conf));
    }

    @Override
    public XAConnection getXAConnection(String username, String password) throws SQLException {
        Configuration conf = this.conf.clone(username, password);
        return new MariaDbPoolConnection(Driver.connect(conf));
    }
}

