/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;

public interface Codec<T> {
    public String className();

    public boolean canDecode(ColumnDefinitionPacket var1, Class<?> var2);

    public boolean canEncode(Object var1);

    public T decodeText(ReadableByteBuf var1, int var2, ColumnDefinitionPacket var3, Calendar var4) throws SQLDataException;

    public T decodeBinary(ReadableByteBuf var1, int var2, ColumnDefinitionPacket var3, Calendar var4) throws SQLDataException;

    public void encodeText(PacketWriter var1, Context var2, Object var3, Calendar var4, Long var5) throws IOException, SQLException;

    public void encodeBinary(PacketWriter var1, Object var2, Calendar var3, Long var4) throws IOException, SQLException;

    default public boolean canEncodeLongData() {
        return false;
    }

    default public void encodeLongData(PacketWriter encoder, T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    default public byte[] encodeData(T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    public int getBinaryEncodeType();
}

