/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec.list;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.DataType;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.type.Geometry;
import com.singlestore.jdbc.type.Point;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;

public class PointCodec
implements Codec<Point> {
    public static final PointCodec INSTANCE = new PointCodec();

    @Override
    public String className() {
        return Point.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(Point.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Point;
    }

    @Override
    public Point decodeText(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal);
    }

    @Override
    public Point decodeBinary(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length - 4, column);
            if (geo instanceof Point) {
                return (Point)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as Point", geo.getClass().getName()));
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Point", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_PointFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        Point pt = (Point)value;
        encoder.writeLength(25L);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(1);
        encoder.writeDouble(pt.getX());
        encoder.writeDouble(pt.getY());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

