/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec.list;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.DataType;
import com.singlestore.jdbc.codec.list.LocalDateTimeCodec;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import java.io.IOException;
import java.sql.SQLDataException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.TimeZone;

public class LocalTimeCodec
implements Codec<LocalTime> {
    public static final LocalTimeCodec INSTANCE = new LocalTimeCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TIME, new DataType[]{DataType.DATETIME, DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    public static int[] parseTime(ReadableByteBuf buf, int length, ColumnDefinitionPacket column) throws SQLDataException {
        int initialPos = buf.pos();
        int[] parts = new int[5];
        parts[0] = 1;
        int idx = 1;
        int partLength = 0;
        int i = 0;
        if (length > 0 && buf.getByte() == 45) {
            buf.skip();
            ++i;
            parts[0] = -1;
        }
        while (i < length) {
            byte b = buf.readByte();
            if (b == 58 || b == 46) {
                ++idx;
                partLength = 0;
            } else {
                if (b < 48 || b > 57) {
                    buf.pos(initialPos);
                    String val = buf.readString(length);
                    throw new SQLDataException(String.format("%s value '%s' cannot be decoded as Time", new Object[]{column.getType(), val}));
                }
                ++partLength;
                parts[idx] = parts[idx] * 10 + (b - 48);
            }
            ++i;
        }
        if (idx < 2) {
            buf.pos(initialPos);
            String val = buf.readString(length);
            throw new SQLDataException(String.format("%s value '%s' cannot be decoded as Time", new Object[]{column.getType(), val}));
        }
        if (idx == 4) {
            for (i = 0; i < 9 - partLength; ++i) {
                parts[4] = parts[4] * 10;
            }
        }
        return parts;
    }

    @Override
    public String className() {
        return LocalTime.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(LocalTime.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalTime;
    }

    @Override
    public LocalTime decodeText(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case TIMESTAMP: 
            case DATETIME: {
                int[] parts = LocalDateTimeCodec.parseTimestamp(buf.readString(length));
                if (parts == null) {
                    return null;
                }
                return LocalTime.of(parts[3], parts[4], parts[5], parts[6]);
            }
            case TIME: {
                int[] parts = LocalTimeCodec.parseTime(buf, length, column);
                parts[1] = parts[1] % 24;
                if (parts[0] == -1) {
                    long seconds = 86400L - ((long)(parts[1] * 3600) + (long)parts[2] * 60L + (long)parts[3]);
                    return LocalTime.ofNanoOfDay(seconds * 1000000000L - (long)parts[4]);
                }
                return LocalTime.of(parts[1] % 24, parts[2], parts[3], parts[4]);
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as LocalTime", new Object[]{column.getType()}));
                }
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                String val = buf.readString(length);
                try {
                    if (val.contains(" ")) {
                        ZoneId tz = cal != null ? cal.getTimeZone().toZoneId() : TimeZone.getDefault().toZoneId();
                        return LocalDateTime.parse(val, LocalDateTimeCodec.SINGLESTORE_LOCAL_DATE_TIME.withZone(tz)).toLocalTime();
                    }
                    return LocalTime.parse(val);
                }
                catch (DateTimeParseException e) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as LocalTime", new Object[]{val, column.getType()}));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as LocalTime", new Object[]{column.getType()}));
    }

    @Override
    public LocalTime decodeBinary(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        byte hour = 0;
        int minutes = 0;
        int seconds = 0;
        long microseconds = 0L;
        switch (column.getType()) {
            case TIMESTAMP: 
            case DATETIME: {
                if (length == 0) {
                    return null;
                }
                buf.skip(4);
                if (length > 4) {
                    hour = buf.readByte();
                    minutes = buf.readByte();
                    seconds = buf.readByte();
                    if (length > 7) {
                        microseconds = buf.readInt();
                    }
                }
                return LocalTime.of(hour, minutes, seconds).plusNanos(microseconds * 1000L);
            }
            case TIME: {
                boolean negate;
                boolean bl = negate = buf.readByte() == 1;
                if (length > 4) {
                    buf.skip(4);
                    if (length > 7) {
                        hour = buf.readByte();
                        minutes = buf.readByte();
                        seconds = buf.readByte();
                        if (length > 8) {
                            microseconds = buf.readInt();
                        }
                    }
                }
                if (negate) {
                    long nanos = 86400 - (hour * 3600 + minutes * 60 + seconds);
                    return LocalTime.ofNanoOfDay(nanos * 1000000000L - microseconds * 1000L);
                }
                return LocalTime.of(hour % 24, minutes, seconds, (int)microseconds * 1000);
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as LocalTime", new Object[]{column.getType()}));
                }
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                String val = buf.readString(length);
                try {
                    if (val.contains(" ")) {
                        ZoneId tz = cal != null ? cal.getTimeZone().toZoneId() : TimeZone.getDefault().toZoneId();
                        return LocalDateTime.parse(val, LocalDateTimeCodec.SINGLESTORE_LOCAL_DATE_TIME.withZone(tz)).toLocalTime();
                    }
                    return LocalTime.parse(val);
                }
                catch (DateTimeParseException e) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as LocalTime", new Object[]{val, column.getType()}));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as LocalTime", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        LocalTime val = (LocalTime)value;
        StringBuilder dateString = new StringBuilder(15);
        dateString.append(val.getHour() < 10 ? "0" : "").append(val.getHour()).append(val.getMinute() < 10 ? ":0" : ":").append(val.getMinute()).append(val.getSecond() < 10 ? ":0" : ":").append(val.getSecond());
        int microseconds = val.getNano() / 1000;
        if (microseconds > 0) {
            dateString.append(".");
            if (microseconds % 1000 == 0) {
                dateString.append(Integer.toString(microseconds / 1000 + 1000).substring(1));
            } else {
                dateString.append(Integer.toString(microseconds + 1000000).substring(1));
            }
        }
        encoder.writeByte(39);
        encoder.writeAscii(dateString.toString());
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        LocalTime val = (LocalTime)value;
        int nano = val.getNano();
        if (nano > 0) {
            encoder.writeByte(12);
            encoder.writeByte(0);
            encoder.writeInt(0);
            encoder.writeByte((byte)val.get(ChronoField.HOUR_OF_DAY));
            encoder.writeByte((byte)val.get(ChronoField.MINUTE_OF_HOUR));
            encoder.writeByte((byte)val.get(ChronoField.SECOND_OF_MINUTE));
            encoder.writeInt(nano / 1000);
        } else {
            encoder.writeByte(8);
            encoder.writeByte(0);
            encoder.writeInt(0);
            encoder.writeByte((byte)val.get(ChronoField.HOUR_OF_DAY));
            encoder.writeByte((byte)val.get(ChronoField.MINUTE_OF_HOUR));
            encoder.writeByte((byte)val.get(ChronoField.SECOND_OF_MINUTE));
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TIME.get();
    }
}

