/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.client;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.StreamingResult;
import com.singlestore.jdbc.client.result.UpdatableResult;
import com.singlestore.jdbc.client.socket.PacketReader;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.message.server.Completion;
import com.singlestore.jdbc.message.server.ErrorPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.util.exceptions.ExceptionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;

public interface ClientMessage {
    public int encode(PacketWriter var1, Context var2) throws IOException, SQLException;

    default public int batchUpdateLength() {
        return 0;
    }

    default public String description() {
        return null;
    }

    default public boolean binaryProtocol() {
        return false;
    }

    default public boolean canSkipMeta() {
        return false;
    }

    default public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, PacketReader reader, PacketWriter writer, Context context, ExceptionFactory exceptionFactory, ReentrantLock lock, boolean traceEnable) throws IOException, SQLException {
        ColumnDefinitionPacket[] ci;
        ReadableByteBuf buf = reader.readPacket(true, traceEnable);
        switch (buf.getUnsignedByte()) {
            case 0: {
                return new OkPacket(buf, context);
            }
            case 255: {
                ErrorPacket errorPacket = new ErrorPacket(buf, context);
                throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            case 251: {
                buf.skip(1);
                String fileName = buf.readStringNullEnd();
                try (FileInputStream is = null;){
                    int len;
                    is = new FileInputStream(fileName);
                    byte[] fileBuf = new byte[8192];
                    while ((len = ((InputStream)is).read(fileBuf)) > 0) {
                        writer.writeBytes(fileBuf, 0, len);
                        writer.flush();
                    }
                    writer.writeEmptyPacket();
                    Completion completion = this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable);
                    return completion;
                }
            }
        }
        int fieldCount = buf.readLengthNotNull();
        if (context.canSkipMeta() && this.canSkipMeta()) {
            boolean skipMeta;
            boolean bl = skipMeta = buf.readByte() == 0;
            if (skipMeta) {
                ci = ((BasePreparedStatement)stmt).getMeta();
            } else {
                ci = new ColumnDefinitionPacket[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    ci[i] = new ColumnDefinitionPacket(reader.readPacket(false, traceEnable), context.isExtendedInfo());
                }
                ((BasePreparedStatement)stmt).updateMeta(ci);
                if (!context.isEofDeprecated()) {
                    reader.readPacket(true, traceEnable);
                }
            }
        } else {
            ci = new ColumnDefinitionPacket[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                ci[i] = new ColumnDefinitionPacket(reader.readPacket(false, traceEnable), context.isExtendedInfo());
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, traceEnable);
            }
        }
        if (resultSetConcurrency == 1008) {
            return new UpdatableResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
        }
        if (fetchSize != 0) {
            if ((context.getServerStatus() & 8) > 0) {
                context.setServerStatus(context.getServerStatus() - 8);
            }
            return new StreamingResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, fetchSize, lock, resultSetType, closeOnCompletion, traceEnable);
        }
        return new CompleteResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
    }
}

