/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.ParameterMetaData;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.client.result.ResultSetMetaData;
import com.singlestore.jdbc.message.client.ClientMessage;
import com.singlestore.jdbc.message.client.PreparePacket;
import com.singlestore.jdbc.message.client.QueryWithParametersPacket;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.message.server.Completion;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.util.ClientParser;
import com.singlestore.jdbc.util.ParameterList;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class ClientPreparedStatement
extends BasePreparedStatement {
    private final ClientParser parser;
    public static final Pattern INSERT_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(INSERT)", 2);
    public static final Pattern INSERT_ON_DUPLICATE_KEY_UPDATE_STATEMENT_PATTERN = Pattern.compile("^.+[^`](ON)\\s.*(DUPLICATE)\\s.*(KEY)\\s.*(UPDATE)[^`].+", 2);

    public ClientPreparedStatement(String sql, Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) throws SQLException {
        super(sql, con, lock, canUseServerTimeout, canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        boolean noBackslashEscapes = (con.getContext().getServerStatus() & 0x200) > 0;
        this.parser = ClientParser.parameterParts(sql, noBackslashEscapes);
        this.parameters = new ParameterList(this.parser.getParamCount());
    }

    protected String preSqlCmd() {
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR ";
        }
        return "";
    }

    private void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        this.lock.lock();
        try {
            QueryWithParametersPacket query = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, this.parameters);
            this.results = this.con.getClient().execute(query, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isRewriteBatchedApplicable(String sql) {
        return INSERT_STATEMENT_PATTERN.matcher(sql).find() && !INSERT_ON_DUPLICATE_KEY_UPDATE_STATEMENT_PATTERN.matcher(sql).find() && !this.parser.isMultiStatement();
    }

    private List<Completion> executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        if (this.con.getContext().getConf().rewriteBatchedStatements() && this.isRewriteBatchedApplicable(this.sql) && this.autoGeneratedKeys != 1) {
            return this.executeBatchWithInsertRewrite();
        }
        return this.executeBatchPipeline();
    }

    private List<Completion> executeBatchWithInsertRewrite() throws SQLException {
        try {
            this.results = this.con.getClient().executePipeline(this.getClientMessageForRewriteBatchedStatement(), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion);
            return this.results;
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private ClientMessage[] getClientMessageForRewriteBatchedStatement() {
        ArrayList<byte[]> partList = new ArrayList<byte[]>();
        ParameterList parameterList = new ParameterList();
        int index = 0;
        byte[] startInsertSectionByte = ",(".getBytes();
        for (int batchCount = 0; batchCount < this.batchParameters.size(); ++batchCount) {
            if (batchCount == 0) {
                partList.add(this.parser.getQueryParts().get(0));
            }
            for (int paramCount = 0; paramCount < this.parser.getParamCount(); ++paramCount) {
                if (paramCount == this.parser.getParamCount() - 1 && batchCount < this.batchParameters.size() - 1) {
                    byte[] queryPartToAppend = new byte[this.parser.getQueryParts().get(paramCount + 1).length + startInsertSectionByte.length];
                    byte[] queryPartOriginal = this.parser.getQueryParts().get(paramCount + 1);
                    System.arraycopy(queryPartOriginal, 0, queryPartToAppend, 0, queryPartOriginal.length);
                    System.arraycopy(startInsertSectionByte, 0, queryPartToAppend, queryPartOriginal.length, startInsertSectionByte.length);
                    partList.add(queryPartToAppend);
                } else {
                    partList.add(this.parser.getQueryParts().get(paramCount + 1));
                }
                parameterList.set(index, ((ParameterList)this.batchParameters.get(batchCount)).get(paramCount));
                ++index;
            }
        }
        int paramCount = this.parser.getParamCount() * this.batchParameters.size();
        ClientParser parser = ClientParser.parameterPartsForRewriteBatchedStatement(this.sql, partList, paramCount);
        return new ClientMessage[]{new QueryWithParametersPacket(this.preSqlCmd(), parser, parameterList)};
    }

    private List<Completion> executeBatchPipeline() throws SQLException {
        ClientMessage[] packets = new ClientMessage[this.batchParameters.size()];
        for (int i = 0; i < this.batchParameters.size(); ++i) {
            packets[i] = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (ParameterList)this.batchParameters.get(i));
        }
        try {
            this.results = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion);
            return this.results;
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private List<Completion> executeBatchStd() throws SQLException {
        try {
            this.results = new ArrayList();
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                this.results.addAll(this.con.getClient().execute(new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (ParameterList)this.batchParameters.get(i)), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion));
            }
            return this.results;
        }
        catch (SQLException bue) {
            BatchUpdateException exception = this.exceptionFactory().createBatchUpdate(this.results, this.batchParameters.size(), bue);
            this.results = null;
            throw exception;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        return this.currResult instanceof Result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return new CompleteResult(new ColumnDefinitionPacket[0], new byte[0][], this.con.getContext());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = new ParameterList();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        } else {
            this.batchParameters.clear();
        }
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parser.getParamCount(); ++i) {
            if (!this.parameters.containsKey(i)) continue;
            throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.canUseServerTimeout && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this);
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new int[0];
        }
        this.lock.lock();
        try {
            List<Completion> res;
            this.results = res = this.executeInternalPreparedBatch();
            int[] updates = new int[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                updates[i] = res.get(i) instanceof OkPacket ? (int)((OkPacket)res.get(i)).getAffectedRows() : -2;
            }
            this.currResult = (Completion)this.results.remove(0);
            int[] nArray = updates;
            return nArray;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new long[0];
        }
        this.lock.lock();
        try {
            List<Completion> res;
            this.results = res = this.executeInternalPreparedBatch();
            long[] updates = new long[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                updates[i] = ((OkPacket)res.get(i)).getAffectedRows();
            }
            this.currResult = (Completion)this.results.remove(0);
            long[] lArray = updates;
            return lArray;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    public ClientParser test_getParser() {
        return this.parser;
    }
}

