/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.socket;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.util.MutableInt;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.LoggerHelper;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PacketReader {
    private static final int REUSABLE_BUFFER_LENGTH = 1024;
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private final Logger logger;
    private final byte[] header = new byte[4];
    private final byte[] reusableArray = new byte[1024];
    private final InputStream inputStream;
    private final int maxQuerySizeToLog;
    private final MutableInt sequence;
    private String serverThreadLog = "";

    public PacketReader(InputStream in, Configuration conf, MutableInt sequence) {
        this.inputStream = in;
        this.maxQuerySizeToLog = conf.maxQuerySizeToLog();
        this.sequence = sequence;
        this.logger = Loggers.getLogger(PacketReader.class);
    }

    public ReadableByteBuf readPacket(boolean reUsable) throws IOException {
        return this.readPacket(reUsable, this.logger.isTraceEnabled());
    }

    public ReadableByteBuf readPacket(boolean reUsable, boolean traceEnable) throws IOException {
        int count;
        int count2;
        int remaining = 4;
        if (traceEnable) {
            this.logger.trace("read header is started, remaining bytes: {}", remaining);
        }
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            if (traceEnable) {
                this.logger.trace("read {} bytes header is finished", count2);
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        int lastPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        this.sequence.set(this.header[3]);
        byte[] rawBytes = reUsable && lastPacketLength < 1024 ? this.reusableArray : new byte[lastPacketLength];
        remaining = lastPacketLength;
        if (traceEnable) {
            this.logger.trace("read content is started, remaining bytes: {}", remaining);
        }
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (lastPacketLength - remaining) + " bytes from " + lastPacketLength + " (socket was closed by server)");
            }
            if (traceEnable) {
                this.logger.trace("read {} bytes content is finished", count);
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (traceEnable) {
            this.logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, 0, lastPacketLength, this.maxQuerySizeToLog));
        }
        if (lastPacketLength == 0xFFFFFF) {
            int packetLength;
            do {
                int count3;
                int count4;
                remaining = 4;
                if (traceEnable) {
                    this.logger.trace("read header is started, remaining bytes: {}", remaining);
                }
                off = 0;
                do {
                    if ((count4 = this.inputStream.read(this.header, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + off + " bytes from 4");
                    }
                    if (traceEnable) {
                        this.logger.trace("read {} bytes header is finished", count4);
                    }
                    off += count4;
                } while ((remaining -= count4) > 0);
                packetLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
                this.sequence.set(this.header[3]);
                int currentbufLength = rawBytes.length;
                byte[] newRawBytes = new byte[currentbufLength + packetLength];
                System.arraycopy(rawBytes, 0, newRawBytes, 0, currentbufLength);
                rawBytes = newRawBytes;
                remaining = packetLength;
                if (traceEnable) {
                    this.logger.trace("read content is started, remaining bytes: {}", remaining);
                }
                off = currentbufLength;
                do {
                    if ((count3 = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + (packetLength - remaining) + " bytes from " + packetLength);
                    }
                    if (traceEnable) {
                        this.logger.trace("read {} bytes content is finished", count3);
                    }
                    off += count3;
                } while ((remaining -= count3) > 0);
                if (traceEnable) {
                    this.logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, currentbufLength, packetLength, this.maxQuerySizeToLog));
                }
                lastPacketLength += packetLength;
            } while (packetLength == 0xFFFFFF);
        }
        return new ReadableByteBuf(this.sequence, rawBytes, lastPacketLength);
    }

    public MutableInt getSequence() {
        return this.sequence;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void setServerThreadId(Long serverThreadId, HostAddress hostAddress) {
        Boolean isMaster = hostAddress != null ? hostAddress.primary : null;
        this.serverThreadLog = "conn=" + (serverThreadId == null ? "-1" : serverThreadId) + (isMaster != null ? " (" + (isMaster != false ? "M" : "S") + ")" : "");
    }
}

