/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.ParameterMetaData;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.client.result.ResultSetMetaData;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.message.client.ExecutePacket;
import com.singlestore.jdbc.message.client.PreparePacket;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.util.ParameterList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class ServerPreparedStatement
extends BasePreparedStatement {
    private static final Pattern PREPARABLE_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|CALL)", 2);

    public ServerPreparedStatement(String sql, Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) throws SQLException {
        super(sql, con, lock, canUseServerTimeout, canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        if (!PREPARABLE_STATEMENT_PATTERN.matcher(sql).find()) {
            this.prepareResult = con.getContext().getPrepareCache().get(sql, this);
            if (this.prepareResult == null) {
                con.getClient().execute(new PreparePacket(sql), this);
            }
        }
        this.parameters = new ParameterList();
    }

    private void prepareIfNotAlready(String cmd) throws SQLException {
        if (this.prepareResult == null) {
            this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
            if (this.prepareResult == null) {
                this.con.getClient().execute(new PreparePacket(cmd), this);
            }
        }
    }

    protected void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        this.lock.lock();
        String cmd = this.escapeTimeout(this.sql);
        if (this.prepareResult == null) {
            this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
        }
        try {
            this.executeStandard(cmd);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeStandard(String cmd) throws SQLException {
        this.prepareIfNotAlready(cmd);
        ExecutePacket execute = new ExecutePacket(this.prepareResult, this.parameters, cmd, this);
        this.results = this.con.getClient().execute(execute, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion);
    }

    private void executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        String cmd = this.escapeTimeout(this.sql);
        this.executeBatchStandard(cmd);
    }

    private void executeBatchStandard(String cmd) throws SQLException {
        ArrayList<Completion> tmpResults = new ArrayList<Completion>();
        SQLException error = null;
        for (Parameters batchParameter : this.batchParameters) {
            if (this.prepareResult == null) {
                this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
                if (this.prepareResult == null) {
                    this.con.getClient().execute(new PreparePacket(cmd), this);
                }
            }
            try {
                ExecutePacket execute = new ExecutePacket(this.prepareResult, batchParameter, cmd, this);
                tmpResults.addAll(this.con.getClient().execute(execute, this));
            }
            catch (SQLException e) {
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            throw this.exceptionFactory().createBatchUpdate(tmpResults, this.batchParameters.size(), error);
        }
        this.results = tmpResults;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.results.size() > 0) {
            this.currResult = (Completion)this.results.remove(0);
            return this.currResult instanceof Result;
        }
        return false;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.canUseServerTimeout && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.results.size() > 0) {
            this.currResult = (Completion)this.results.remove(0);
            if (this.currResult instanceof Result) {
                return (Result)this.currResult;
            }
        }
        return new CompleteResult(new ColumnDefinitionPacket[0], new byte[0][], this.con.getContext());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    protected void handleParameterOutput() throws SQLException {
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = new ParameterList(this.parameters.size());
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        } else {
            this.batchParameters.clear();
        }
    }

    protected void validParameters() throws SQLException {
        if (this.prepareResult != null) {
            for (int i = 0; i < this.prepareResult.getParameters().length; ++i) {
                if (!this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        } else {
            if (this.batchParameters != null && !this.batchParameters.isEmpty() && this.parameters.size() < ((Parameters)this.batchParameters.get(0)).size()) {
                throw this.exceptionFactory().create("batch set of parameters differ from previous set. All parameters must be set", "07004");
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this);
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new int[0];
        }
        this.lock.lock();
        try {
            int i;
            this.executeInternalPreparedBatch();
            int[] updates = new int[this.batchParameters.size()];
            if (this.results.size() != this.batchParameters.size()) {
                for (i = 0; i < this.batchParameters.size(); ++i) {
                    updates[i] = -2;
                }
            } else {
                for (i = 0; i < Math.min(this.results.size(), this.batchParameters.size()); ++i) {
                    updates[i] = this.results.get(i) instanceof OkPacket ? (int)((OkPacket)this.results.get(i)).getAffectedRows() : -2;
                }
            }
            this.currResult = (Completion)this.results.remove(0);
            int[] nArray = updates;
            return nArray;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new long[0];
        }
        this.lock.lock();
        try {
            int i;
            this.executeInternalPreparedBatch();
            long[] updates = new long[this.batchParameters.size()];
            if (this.results.size() != this.batchParameters.size()) {
                for (i = 0; i < this.batchParameters.size(); ++i) {
                    updates[i] = -2L;
                }
            } else {
                for (i = 0; i < this.results.size(); ++i) {
                    updates[i] = ((OkPacket)this.results.get(i)).getAffectedRows();
                }
            }
            this.currResult = (Completion)this.results.remove(0);
            long[] lArray = updates;
            return lArray;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    public void reset() {
        this.lock.lock();
        try {
            this.prepareResult = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

