/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.impl;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.ServerPreparedStatement;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.Client;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.BaseContext;
import com.singlestore.jdbc.client.context.RedoContext;
import com.singlestore.jdbc.client.impl.ConnectionHelper;
import com.singlestore.jdbc.client.impl.PrepareCache;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.client.result.StreamingResult;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.socket.impl.CompressInputStream;
import com.singlestore.jdbc.client.socket.impl.CompressOutputStream;
import com.singlestore.jdbc.client.socket.impl.PacketReader;
import com.singlestore.jdbc.client.socket.impl.PacketWriter;
import com.singlestore.jdbc.client.socket.impl.ReadAheadBufferedStream;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.export.MaxAllowedPacketException;
import com.singlestore.jdbc.export.Prepare;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.message.client.ClosePreparePacket;
import com.singlestore.jdbc.message.client.HandshakeResponse;
import com.singlestore.jdbc.message.client.QueryPacket;
import com.singlestore.jdbc.message.client.QuitPacket;
import com.singlestore.jdbc.message.server.ErrorPacket;
import com.singlestore.jdbc.message.server.InitialHandshakePacket;
import com.singlestore.jdbc.message.server.PrepareResultPacket;
import com.singlestore.jdbc.plugin.Credential;
import com.singlestore.jdbc.plugin.CredentialPlugin;
import com.singlestore.jdbc.plugin.credential.browser.BrowserCredentialPlugin;
import com.singlestore.jdbc.util.Security;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocket;

public class StandardClient
implements Client,
AutoCloseable {
    protected final ExceptionFactory exceptionFactory;
    private Socket socket;
    private final MutableInt sequence = new MutableInt();
    private final MutableInt compressionSequence = new MutableInt();
    private final ReentrantLock lock;
    private final Configuration conf;
    private final HostAddress hostAddress;
    private final boolean disablePipeline;
    protected Writer writer;
    protected Context context;
    private boolean closed = false;
    private PacketReader reader;
    private Statement streamStmt = null;
    private ClientMessage streamMsg = null;
    private int socketTimeout;
    private int waitTimeout;
    protected boolean timeOut;

    private TimerTask getTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Thread cancelThread = new Thread(){

                    @Override
                    public void run() {
                        boolean lockStatus = StandardClient.this.lock.tryLock();
                        if (!StandardClient.this.closed) {
                            StandardClient.this.closed = true;
                            StandardClient.this.timeOut = true;
                            if (!lockStatus) {
                                try (StandardClient cli = new StandardClient(StandardClient.this.conf, StandardClient.this.hostAddress, new ReentrantLock(), true);){
                                    cli.execute(new QueryPacket("KILL " + StandardClient.this.context.getThreadId()));
                                }
                                catch (SQLException sQLException) {}
                            } else {
                                try {
                                    QuitPacket.INSTANCE.encode(StandardClient.this.writer, StandardClient.this.context);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (StandardClient.this.streamStmt != null) {
                                try {
                                    StandardClient.this.streamStmt.abort();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                            }
                            StandardClient.this.closeSocket();
                        }
                        if (lockStatus) {
                            StandardClient.this.lock.unlock();
                        }
                    }
                };
                cancelThread.start();
            }
        };
    }

    public StandardClient(Configuration conf, HostAddress hostAddress, ReentrantLock lock, boolean skipPostCommands) throws SQLException {
        this.conf = conf;
        this.lock = lock;
        this.hostAddress = hostAddress;
        this.exceptionFactory = new ExceptionFactory(conf, hostAddress);
        this.disablePipeline = conf.disablePipeline();
        this.socketTimeout = conf.socketTimeout();
        String host = hostAddress != null ? hostAddress.host : null;
        try {
            this.connect(host, skipPostCommands);
        }
        catch (SQLInvalidAuthorizationSpecException sqlException) {
            if (conf.credentialPlugin() != null && conf.credentialPlugin().type().contains("BROWSER_SSO") && sqlException.getErrorCode() == 1045 || sqlException.getErrorCode() == 2628) {
                BrowserCredentialPlugin credPlugin = (BrowserCredentialPlugin)conf.credentialPlugin();
                Loggers.getLogger(StandardClient.class).debug("Failed to connect with the JWT, retrying browser auth");
                credPlugin.clearKeyring();
                credPlugin.clearLocalCache();
                this.closed = false;
                this.connect(host, skipPostCommands);
            }
            throw sqlException;
        }
    }

    private void connect(String host, boolean skipPostCommands) throws SQLException {
        this.socket = ConnectionHelper.connectSocket(this.conf, this.hostAddress);
        try {
            ReadableByteBuf buf;
            OutputStream out = this.socket.getOutputStream();
            FilterInputStream in = this.conf.useReadAheadInput() ? new ReadAheadBufferedStream(this.socket.getInputStream()) : new BufferedInputStream(this.socket.getInputStream(), 16384);
            this.assignStream(out, in, this.conf, null);
            if (this.conf.socketTimeout() > 0) {
                this.setSocketTimeout(this.conf.socketTimeout());
            }
            if ((buf = this.reader.readPacket(true)).getByte() == -1) {
                ErrorPacket errorPacket = new ErrorPacket(buf, null);
                throw this.exceptionFactory.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            InitialHandshakePacket handshake = InitialHandshakePacket.decode(buf);
            this.exceptionFactory.setThreadId(handshake.getThreadId());
            long clientCapabilities = ConnectionHelper.initializeClientCapabilities(this.conf, handshake.getCapabilities(), this.hostAddress);
            this.context = this.conf.transactionReplay() ? new RedoContext(handshake, clientCapabilities, this.conf, this.exceptionFactory, new PrepareCache(this.conf.prepStmtCacheSize(), this)) : new BaseContext(handshake, clientCapabilities, this.conf, this.exceptionFactory, new PrepareCache(this.conf.prepStmtCacheSize(), this));
            this.reader.setServerThreadId(handshake.getThreadId(), this.hostAddress);
            this.writer.setServerThreadId(handshake.getThreadId(), this.hostAddress);
            byte exchangeCharset = ConnectionHelper.decideLanguage(handshake);
            SSLSocket sslSocket = ConnectionHelper.sslWrapper(this.hostAddress, this.socket, clientCapabilities, exchangeCharset, this.context, this.writer);
            if (sslSocket != null) {
                out = sslSocket.getOutputStream();
                in = this.conf.useReadAheadInput() ? new ReadAheadBufferedStream(sslSocket.getInputStream()) : new BufferedInputStream(sslSocket.getInputStream(), 16384);
                this.assignStream(out, in, this.conf, handshake.getThreadId());
            }
            String authenticationPluginType = handshake.getAuthenticationPluginType();
            CredentialPlugin credentialPlugin = this.conf.credentialPlugin();
            if (credentialPlugin != null && credentialPlugin.defaultAuthenticationPluginType() != null) {
                authenticationPluginType = credentialPlugin.defaultAuthenticationPluginType();
            }
            if ("mysql_clear_password".equals(authenticationPluginType) && sslSocket == null) {
                throw new IllegalStateException("Cannot send password in clear text if SSL is not enabled.");
            }
            Credential credential = ConnectionHelper.loadCredential(credentialPlugin, this.conf, this.hostAddress);
            new HandshakeResponse(credential, authenticationPluginType, this.context.getSeed(), this.conf, host, clientCapabilities, exchangeCharset).encode(this.writer, this.context);
            this.writer.flush();
            ConnectionHelper.authenticationHandler(credential, this.writer, this.reader, this.context);
            if ((clientCapabilities & 0x20L) != 0L) {
                this.assignStream(new CompressOutputStream(out, this.compressionSequence), new CompressInputStream(in, this.compressionSequence), this.conf, handshake.getThreadId());
            }
            if (!skipPostCommands) {
                this.postConnectionQueries();
            }
        }
        catch (IOException ioException) {
            this.destroySocket();
            String errorMsg = String.format("Could not connect to %s:%s : %s", host, this.socket.getPort(), ioException.getMessage());
            if (host == null) {
                errorMsg = String.format("Could not connect to socket : %s", ioException.getMessage());
            }
            throw this.exceptionFactory.create(errorMsg, "08000", ioException);
        }
        catch (SQLException sqlException) {
            this.destroySocket();
            throw sqlException;
        }
    }

    private void assignStream(OutputStream out, InputStream in, Configuration conf, Long threadId) {
        this.writer = new PacketWriter(out, conf.maxQuerySizeToLog(), this.sequence, this.compressionSequence);
        this.writer.setServerThreadId(threadId, this.hostAddress);
        this.reader = new PacketReader(in, conf, this.sequence);
        this.reader.setServerThreadId(threadId, this.hostAddress);
    }

    protected void destroySocket() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void postConnectionQueries() throws SQLException {
        ArrayList<String> commands = new ArrayList<String>();
        int resInd = 0;
        if (this.conf.sessionVariables() != null) {
            commands.add("set " + Security.parseSessionVariables(this.conf.sessionVariables()));
            ++resInd;
        }
        if (this.conf.transactionIsolation() != null) {
            commands.add("set tx_isolation='" + this.conf.transactionIsolation().getValue() + "'");
            ++resInd;
        }
        if (this.conf.autocommit() != null) {
            commands.add("set autocommit=" + (this.conf.autocommit() != false ? "true" : "false"));
            ++resInd;
        }
        if (this.conf.database() != null && this.conf.createDatabaseIfNotExist() && (this.hostAddress == null || this.hostAddress.primary.booleanValue())) {
            String escapedDb = this.conf.database().replace("`", "``");
            commands.add(String.format("CREATE DATABASE IF NOT EXISTS `%s`", escapedDb));
            commands.add(String.format("USE `%s`", escapedDb));
            resInd += 2;
        }
        if (this.conf.initSql() != null) {
            commands.add(this.conf.initSql());
            ++resInd;
        }
        if (this.conf.nonMappedOptions().containsKey("initSql")) {
            String[] initialCommands = this.conf.nonMappedOptions().get("initSql").toString().split(";");
            commands.addAll(Arrays.asList(initialCommands));
            resInd += initialCommands.length;
        }
        commands.add("SELECT @@max_allowed_packet, @@wait_timeout");
        try {
            ClientMessage[] msgs = new ClientMessage[commands.size()];
            for (int i = 0; i < commands.size(); ++i) {
                msgs[i] = new QueryPacket((String)commands.get(i));
            }
            List<Completion> res = this.executePipeline(msgs, null, 0, 0L, 1007, 1003, false);
            Result result = (Result)res.get(resInd);
            result.next();
            this.waitTimeout = Integer.parseInt(result.getString(2));
            this.writer.setMaxAllowedPacket(Integer.parseInt(result.getString(1)));
        }
        catch (SQLException sqlException) {
            throw this.exceptionFactory.create("Initialization command fail", "08000", sqlException);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
    }

    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            Logger logger = Loggers.getLogger(StandardClient.class);
            if (logger.isDebugEnabled() && message.description() != null) {
                logger.debug("execute query: {}", message.description());
            }
            return message.encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            if (ioException instanceof MaxAllowedPacketException) {
                if (((MaxAllowedPacketException)ioException).isMustReconnect()) {
                    this.destroySocket();
                    throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", ioException);
                }
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", ioException);
            }
            this.destroySocket();
            if (this.timeOut) {
                throw this.exceptionFactory.withSql(message.description()).create("Socket error: query timed out", "08000", ioException);
            }
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message) throws SQLException {
        return this.execute(message, null, 0, 0L, 1007, 1003, false);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt) throws SQLException {
        return this.execute(message, stmt, 0, 0L, 1007, 1003, false);
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        ArrayList<Completion> results = new ArrayList<Completion>();
        int readCounter = 0;
        int[] responseMsg = new int[messages.length];
        try {
            if (this.disablePipeline) {
                for (readCounter = 0; readCounter < messages.length; ++readCounter) {
                    results.addAll(this.execute(messages[readCounter], stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                }
            } else {
                for (int i = 0; i < messages.length; ++i) {
                    responseMsg[i] = this.sendQuery(messages[i]);
                }
                while (readCounter < messages.length) {
                    ++readCounter;
                    for (int j = 0; j < responseMsg[readCounter - 1]; ++j) {
                        results.addAll(this.readResponse(stmt, messages[readCounter - 1], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                    }
                }
            }
            return results;
        }
        catch (SQLException sqlException) {
            for (int i = readCounter; i < messages.length; ++i) {
                for (int j = 0; j < responseMsg[i]; ++j) {
                    try {
                        results.addAll(this.readResponse(stmt, messages[i], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                        continue;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            for (Completion result : results) {
                if (!(result instanceof PrepareResultPacket) || !(stmt instanceof ServerPreparedStatement)) continue;
                try {
                    ((PrepareResultPacket)result).decrementUse(this, (ServerPreparedStatement)stmt);
                }
                catch (SQLException sQLException) {}
            }
            int batchUpdateLength = 0;
            for (ClientMessage message : messages) {
                batchUpdateLength += message.batchUpdateLength();
            }
            throw this.exceptionFactory.createBatchUpdate(results, batchUpdateLength, responseMsg, sqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        if (stmt != null && stmt.getQueryTimeout() > 0) {
            Timer cancelTimer = new Timer();
            try {
                cancelTimer.schedule(this.getTimerTask(), stmt.getQueryTimeout() * 1000);
                this.sendQuery(message);
                List<Completion> list = this.readResponse(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
                return list;
            }
            finally {
                cancelTimer.cancel();
            }
        }
        this.sendQuery(message);
        return this.readResponse(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
    }

    public List<Completion> readResponse(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        return completions;
    }

    public void readResponse(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(null, message, completions, 0, 0L, 1007, 1003, false);
    }

    @Override
    public void closePrepare(Prepare prepare) throws SQLException {
        this.checkNotClosed();
        try {
            new ClosePreparePacket(prepare.getStatementId()).encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.create("Socket error during post connection queries: " + ioException.getMessage(), "08000", ioException);
        }
    }

    @Override
    public void readStreamingResults(List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        if (this.streamStmt != null) {
            this.readResults(this.streamStmt, this.streamMsg, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
    }

    private void readResults(Statement stmt, ClientMessage message, List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        while ((this.context.getServerStatus() & 8) > 0) {
            completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        }
    }

    public Completion readPacket(ClientMessage message) throws SQLException {
        return this.readPacket(null, message, 0, 0L, 1007, 1003, false);
    }

    public Completion readPacket(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        try {
            boolean traceEnable = Loggers.getLogger(StandardClient.class).isTraceEnabled();
            Completion completion = message.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, this.reader, this.writer, this.context, this.exceptionFactory, this.lock, traceEnable);
            if (completion instanceof StreamingResult && !((StreamingResult)completion).loaded()) {
                this.streamStmt = stmt;
                this.streamMsg = message;
            }
            return completion;
        }
        catch (IOException ioException) {
            this.destroySocket();
            if (this.timeOut) {
                throw this.exceptionFactory.withSql(message.description()).create("Socket error: query timed out", "08000", ioException);
            }
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            if (this.timeOut) {
                throw this.exceptionFactory.create("Connection is closed due to query timed out", "08000", 1220);
            }
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            try {
                long maxCurrentMillis = System.currentTimeMillis() + 10L;
                this.socket.shutdownOutput();
                this.socket.setSoTimeout(3);
                InputStream is = this.socket.getInputStream();
                while (is.read() != -1 && System.currentTimeMillis() < maxCurrentMillis) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer.close();
            this.reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        SQLPermission sqlPermission = new SQLPermission("callAbort");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(sqlPermission);
        }
        if (executor == null) {
            throw this.exceptionFactory.create("Cannot abort the connection: null executor passed");
        }
        boolean lockStatus = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            if (!lockStatus) {
                try (StandardClient cli = new StandardClient(this.conf, this.hostAddress, new ReentrantLock(), true);){
                    cli.execute(new QueryPacket("KILL " + this.context.getThreadId()));
                }
                catch (SQLException sQLException) {}
            } else {
                try {
                    QuitPacket.INSTANCE.encode(this.writer, this.context);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.streamStmt != null) {
                this.streamStmt.abort();
            }
            this.closeSocket();
        }
        if (lockStatus) {
            this.lock.unlock();
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int milliseconds) throws SQLException {
        try {
            this.socketTimeout = milliseconds;
            this.socket.setSoTimeout(milliseconds);
        }
        catch (SocketException se) {
            throw this.exceptionFactory.create("Cannot set the network timeout", "42000", se);
        }
    }

    @Override
    public void close() throws SQLException {
        boolean locked = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            try {
                QuitPacket.INSTANCE.encode(this.writer, this.context);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeSocket();
        }
        if (locked) {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isPrimary() {
        return this.hostAddress.primary;
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public void reset() {
        this.context.resetStateFlag();
        this.context.resetPrepareCache();
    }
}

