/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.Column;
import com.singlestore.jdbc.codec.RowDecoder;
import com.singlestore.jdbc.plugin.Codec;
import com.singlestore.jdbc.plugin.codec.BooleanCodec;
import com.singlestore.jdbc.plugin.codec.ByteCodec;
import com.singlestore.jdbc.plugin.codec.DoubleCodec;
import com.singlestore.jdbc.plugin.codec.FloatCodec;
import com.singlestore.jdbc.plugin.codec.IntCodec;
import com.singlestore.jdbc.plugin.codec.LongCodec;
import com.singlestore.jdbc.plugin.codec.ShortCodec;
import java.sql.SQLException;
import java.util.Calendar;

public class BinaryRowDecoder
extends RowDecoder {
    private byte[] nullBitmap;

    public BinaryRowDecoder(int columnCount, Column[] columns, Configuration conf) {
        super(columnCount, columns, conf);
    }

    @Override
    public <T> T decode(Codec<T> codec, Calendar cal) throws SQLException {
        return codec.decodeBinary(this.readBuf, this.length, this.columns[this.index], cal);
    }

    @Override
    public byte decodeByte() throws SQLException {
        return ByteCodec.INSTANCE.decodeBinaryByte(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public boolean decodeBoolean() throws SQLException {
        return BooleanCodec.INSTANCE.decodeBinaryBoolean(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public short decodeShort() throws SQLException {
        return ShortCodec.INSTANCE.decodeBinaryShort(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public int decodeInt() throws SQLException {
        return IntCodec.INSTANCE.decodeBinaryInt(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public long decodeLong() throws SQLException {
        return LongCodec.INSTANCE.decodeBinaryLong(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public float decodeFloat() throws SQLException {
        return FloatCodec.INSTANCE.decodeBinaryFloat(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public double decodeDouble() throws SQLException {
        return DoubleCodec.INSTANCE.decodeBinaryDouble(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public void setRow(byte[] buf) {
        if (buf != null) {
            this.readBuf.buf(buf, buf.length).pos(1);
            this.nullBitmap = new byte[(this.columnCount + 9) / 8];
            this.readBuf.readBytes(this.nullBitmap).mark();
        } else {
            this.readBuf.buf(null, 0);
        }
        this.index = -1;
    }

    @Override
    public boolean wasNull() {
        return (this.nullBitmap[(this.index + 2) / 8] & 1 << (this.index + 2) % 8) > 0;
    }

    @Override
    public void setPosition(int newIndex) {
        if (this.index >= newIndex) {
            this.index = 0;
            this.readBuf.reset();
        } else {
            ++this.index;
        }
        while (this.index < newIndex) {
            if ((this.nullBitmap[(this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                block0 : switch (this.columns[this.index].getType()) {
                    case BIGINT: 
                    case DOUBLE: {
                        this.readBuf.skip(8);
                        break;
                    }
                    case INT: 
                    case MEDIUMINT: 
                    case FLOAT: {
                        this.readBuf.skip(4);
                        break;
                    }
                    case SMALLINT: 
                    case YEAR: {
                        this.readBuf.skip(2);
                        break;
                    }
                    case TINYINT: {
                        this.readBuf.skip(1);
                        break;
                    }
                    default: {
                        short type = this.readBuf.readUnsignedByte();
                        switch (type) {
                            case 251: {
                                break block0;
                            }
                            case 252: {
                                this.readBuf.skip(this.readBuf.readUnsignedShort());
                                break block0;
                            }
                            case 253: {
                                this.readBuf.skip(this.readBuf.readUnsignedMedium());
                                break block0;
                            }
                            case 254: {
                                this.readBuf.skip((int)this.readBuf.readLong());
                                break block0;
                            }
                        }
                        this.readBuf.skip(type);
                    }
                }
            }
            ++this.index;
        }
        if ((this.nullBitmap[(this.index + 2) / 8] & 1 << (this.index + 2) % 8) > 0) {
            this.length = -1;
            return;
        }
        switch (this.columns[this.index].getType()) {
            case BIGINT: 
            case DOUBLE: {
                this.length = 8;
                return;
            }
            case INT: 
            case MEDIUMINT: 
            case FLOAT: {
                this.length = 4;
                return;
            }
            case SMALLINT: 
            case YEAR: {
                this.length = 2;
                return;
            }
            case TINYINT: {
                this.length = 1;
                return;
            }
        }
        short len = this.readBuf.readUnsignedByte();
        switch (len) {
            case 251: {
                throw new IllegalStateException("null data is encoded in binary protocol but NULL-Bitmap is not set");
            }
            case 252: {
                this.length = this.readBuf.readUnsignedShort();
                return;
            }
            case 253: {
                this.length = this.readBuf.readUnsignedMedium();
                return;
            }
            case 254: {
                this.length = (int)this.readBuf.readLong();
                return;
            }
        }
        this.length = len;
    }
}

