/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.export;

import com.singlestore.jdbc.HostAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;

public enum HaMode {
    REPLICATION("replication"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return HaMode.getAvailableHostInOrder(hostAddresses, denyList, primary);
        }
    }
    ,
    SEQUENTIAL("sequential"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return 2.getAvailableHostInOrder(hostAddresses, denyList, primary);
        }
    }
    ,
    LOADBALANCE("load-balance"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            ArrayList<HostAddress> loopAddress = new ArrayList<HostAddress>(hostAddresses);
            loopAddress.removeAll(denyList.keySet());
            Collections.shuffle(loopAddress, new Random());
            return loopAddress.stream().filter(e -> e.primary == primary).findFirst();
        }
    }
    ,
    NONE(""){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return hostAddresses.isEmpty() ? Optional.empty() : Optional.of(hostAddresses.get(0));
        }
    };

    private final String value;

    private HaMode(String value) {
        this.value = value;
    }

    public static HaMode from(String value) {
        for (HaMode haMode : HaMode.values()) {
            if (!haMode.value.equalsIgnoreCase(value) && !haMode.name().equalsIgnoreCase(value)) continue;
            return haMode;
        }
        throw new IllegalArgumentException(String.format("Wrong argument value '%s' for HaMode", value));
    }

    public static Optional<HostAddress> getAvailableHostInOrder(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> blacklist, boolean primary) {
        for (int i = 0; i < hostAddresses.size(); ++i) {
            HostAddress hostAddress = hostAddresses.get(i);
            if (hostAddress.primary != primary) continue;
            if (!blacklist.containsKey(hostAddress)) {
                return Optional.of(hostAddress);
            }
            if ((Long)blacklist.get(hostAddress) >= System.currentTimeMillis()) continue;
            blacklist.remove(hostAddress);
            return Optional.of(hostAddress);
        }
        return Optional.empty();
    }

    public abstract Optional<HostAddress> getAvailableHost(List<HostAddress> var1, ConcurrentMap<HostAddress, Long> var2, boolean var3);
}

