/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.Column;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.StreamingResult;
import com.singlestore.jdbc.client.result.UpdatableResult;
import com.singlestore.jdbc.client.socket.Reader;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.message.server.ErrorPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;

public interface ClientMessage {
    public int encode(Writer var1, Context var2) throws IOException, SQLException;

    default public int batchUpdateLength() {
        return 0;
    }

    default public String description() {
        return null;
    }

    default public boolean binaryProtocol() {
        return false;
    }

    default public boolean canSkipMeta() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ReentrantLock lock, boolean traceEnable) throws IOException, SQLException {
        Column[] ci;
        block25: {
            int fieldCount;
            block24: {
                boolean skipMeta;
                ReadableByteBuf buf = reader.readPacket(false, traceEnable);
                switch (buf.getUnsignedByte()) {
                    case 0: {
                        return new OkPacket(buf, context);
                    }
                    case 255: {
                        ErrorPacket errorPacket = new ErrorPacket(buf, context);
                        throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
                    }
                    case 251: {
                        buf.skip(1);
                        String fileName = buf.readStringNullEnd();
                        InputStream is = stmt.getNextLocalInfileInputStream();
                        stmt.setNextLocalInfileInputStream(null);
                        if (is == null) {
                            try {
                                is = new FileInputStream(fileName);
                            }
                            catch (FileNotFoundException f) {
                                writer.writeEmptyPacket();
                                this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable);
                                throw exceptionFactory.withSql(this.description()).create("Could not send file : " + f.getMessage(), "HY000", f);
                            }
                        }
                        try {
                            byte[] streamBuf = new byte[8192];
                            while (true) {
                                int len;
                                try {
                                    len = is.read(streamBuf);
                                }
                                catch (IOException e) {
                                    throw exceptionFactory.withSql(this.description()).create("Could not read the input stream : " + e.getMessage(), "HY000", e);
                                }
                                if (len > 0) {
                                    writer.writeBytes(streamBuf, 0, len);
                                    writer.flush();
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            is.close();
                        }
                        writer.writeEmptyPacket();
                        return this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable);
                    }
                }
                fieldCount = buf.readLengthNotNull();
                if (!context.canSkipMeta() || !this.canSkipMeta()) break block24;
                boolean bl = skipMeta = buf.readByte() == 0;
                if (skipMeta) {
                    ci = ((BasePreparedStatement)stmt).getMeta();
                    break block25;
                } else {
                    ci = new Column[fieldCount];
                    for (int i = 0; i < fieldCount; ++i) {
                        ci[i] = new ColumnDefinitionPacket(reader.readPacket(false, traceEnable), context.isExtendedInfo());
                    }
                    ((BasePreparedStatement)stmt).updateMeta(ci);
                    if (!context.isEofDeprecated()) {
                        reader.readPacket(false, traceEnable);
                    }
                }
                break block25;
            }
            ci = new ColumnDefinitionPacket[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                ci[i] = new ColumnDefinitionPacket(reader.readPacket(false, traceEnable), context.isExtendedInfo());
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(false, traceEnable);
            }
        }
        if (resultSetConcurrency == 1008) {
            return new UpdatableResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
        }
        if (fetchSize == 0) {
            return new CompleteResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
        }
        if ((context.getServerStatus() & 8) > 0) {
            context.setServerStatus(context.getServerStatus() - 8);
        }
        return new StreamingResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, fetchSize, lock, resultSetType, closeOnCompletion, traceEnable);
    }
}

