/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.client;

import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.codec.Parameter;
import com.singlestore.jdbc.message.client.RedoableClientMessage;
import com.singlestore.jdbc.plugin.codec.ByteArrayCodec;
import com.singlestore.jdbc.util.ClientParser;
import java.io.IOException;
import java.sql.SQLException;

public final class QueryWithParametersPacket
implements RedoableClientMessage {
    private final String preSqlCmd;
    private final ClientParser parser;
    private Parameters parameters;

    public QueryWithParametersPacket(String preSqlCmd, ClientParser parser, Parameters parameters) {
        this.preSqlCmd = preSqlCmd;
        this.parser = parser;
        this.parameters = parameters;
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            com.singlestore.jdbc.client.util.Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            this.parameters.set(i, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
        }
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public int encode(Writer encoder, Context context) throws IOException, SQLException {
        encoder.initPacket();
        encoder.writeByte(3);
        if (!this.preSqlCmd.isEmpty()) {
            encoder.writeAscii(this.preSqlCmd);
        }
        if (this.parser.getParamCount() == 0) {
            encoder.writeBytes(this.parser.getQueryParts().get(0));
        } else {
            encoder.writeBytes(this.parser.getQueryParts().get(0));
            for (int i = 0; i < this.parser.getParamCount(); ++i) {
                if (this.parameters.get(i).isNull()) {
                    encoder.writeAscii("null");
                } else {
                    this.parameters.get(i).encodeText(encoder, context);
                }
                encoder.writeBytes(this.parser.getQueryParts().get(i + 1));
            }
        }
        encoder.flush();
        return 1;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String description() {
        return this.parser.getSql();
    }
}

