/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.Column;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.plugin.Codec;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLDataException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.EnumSet;

public class StringCodec
implements Codec<String> {
    public static final StringCodec INSTANCE = new StringCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BIT, new DataType[]{DataType.OLDDECIMAL, DataType.TINYINT, DataType.SMALLINT, DataType.INT, DataType.FLOAT, DataType.DOUBLE, DataType.TIMESTAMP, DataType.BIGINT, DataType.MEDIUMINT, DataType.DATE, DataType.TIME, DataType.DATETIME, DataType.YEAR, DataType.NEWDATE, DataType.JSON, DataType.DECIMAL, DataType.ENUM, DataType.SET, DataType.VARCHAR, DataType.CHAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return String.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(String.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof String;
    }

    @Override
    public String decodeText(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case BIT: {
                byte[] bytes = new byte[length];
                buf.readBytes(bytes);
                StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
                sb.append("b'");
                boolean firstByteNonZero = false;
                for (int i = 0; i < 8 * bytes.length; ++i) {
                    boolean b;
                    boolean bl = b = (bytes[i / 8] & 1 << 7 - i % 8) > 0;
                    if (b) {
                        sb.append('1');
                        firstByteNonZero = true;
                        continue;
                    }
                    if (!firstByteNonZero) continue;
                    sb.append('0');
                }
                sb.append("'");
                return sb.toString();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as String", new Object[]{column.getType()}));
                }
                return buf.readString(length);
            }
        }
        return buf.readString(length);
    }

    @Override
    public String decodeBinary(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case BIT: {
                byte[] bytes = new byte[length];
                buf.readBytes(bytes);
                StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
                sb.append("b'");
                boolean firstByteNonZero = false;
                for (int i = 0; i < 8 * bytes.length; ++i) {
                    boolean b;
                    boolean bl = b = (bytes[i / 8] & 1 << 7 - i % 8) > 0;
                    if (b) {
                        sb.append('1');
                        firstByteNonZero = true;
                        continue;
                    }
                    if (!firstByteNonZero) continue;
                    sb.append('0');
                }
                sb.append("'");
                return sb.toString();
            }
            case TINYINT: {
                if (!column.isSigned()) {
                    return String.valueOf(buf.readUnsignedByte());
                }
                return String.valueOf(buf.readByte());
            }
            case YEAR: {
                StringBuilder s = new StringBuilder(String.valueOf(buf.readUnsignedShort()));
                while ((long)s.length() < column.getLength()) {
                    s.insert(0, "0");
                }
                return s.toString();
            }
            case SMALLINT: {
                if (!column.isSigned()) {
                    return String.valueOf(buf.readUnsignedShort());
                }
                return String.valueOf(buf.readShort());
            }
            case MEDIUMINT: {
                String mediumStr = String.valueOf(column.isSigned() ? buf.readMedium() : buf.readUnsignedMedium());
                buf.skip();
                return mediumStr;
            }
            case INT: {
                if (!column.isSigned()) {
                    return String.valueOf(buf.readUnsignedInt());
                }
                return String.valueOf(buf.readInt());
            }
            case BIGINT: {
                BigInteger val;
                if (column.isSigned()) {
                    val = BigInteger.valueOf(buf.readLong());
                } else {
                    byte[] bb = new byte[8];
                    for (int ii = 7; ii >= 0; --ii) {
                        bb[ii] = buf.readByte();
                    }
                    val = new BigInteger(1, bb);
                }
                return new BigDecimal(String.valueOf(val)).setScale(column.getDecimals()).toPlainString();
            }
            case FLOAT: {
                return String.valueOf(buf.readFloat());
            }
            case DOUBLE: {
                return String.valueOf(buf.readDouble());
            }
            case TIME: {
                boolean negate;
                long tDays = 0L;
                int tHours = 0;
                byte tMinutes = 0;
                byte tSeconds = 0;
                long tMicroseconds = 0L;
                if (length == 0) {
                    StringBuilder zeroValue = new StringBuilder("00:00:00");
                    if (column.getDecimals() > 0) {
                        zeroValue.append(".");
                        for (int i = 0; i < column.getDecimals(); ++i) {
                            zeroValue.append("0");
                        }
                    }
                    return zeroValue.toString();
                }
                boolean bl = negate = buf.readByte() == 1;
                if (length > 4) {
                    tDays = buf.readUnsignedInt();
                    if (length > 7) {
                        tHours = buf.readByte();
                        tMinutes = buf.readByte();
                        tSeconds = buf.readByte();
                        if (length > 8) {
                            tMicroseconds = buf.readInt();
                        }
                    }
                }
                int totalHour = (int)(tDays * 24L + (long)tHours);
                String stTime = (negate ? "-" : "") + (totalHour < 10 ? "0" : "") + totalHour + ":" + (tMinutes < 10 ? "0" : "") + tMinutes + ":" + (tSeconds < 10 ? "0" : "") + tSeconds;
                if (column.getDecimals() == 0) {
                    return stTime;
                }
                StringBuilder stMicro = new StringBuilder(String.valueOf(tMicroseconds));
                while (stMicro.length() < column.getDecimals()) {
                    stMicro.insert(0, "0");
                }
                return stTime + "." + stMicro;
            }
            case DATE: {
                if (length == 0) {
                    return "0000-00-00";
                }
                int dateYear = buf.readUnsignedShort();
                byte dateMonth = buf.readByte();
                byte dateDay = buf.readByte();
                return LocalDate.of(dateYear, dateMonth, (int)dateDay).toString();
            }
            case DATETIME: 
            case TIMESTAMP: {
                if (length == 0) {
                    StringBuilder zeroValue = new StringBuilder("0000-00-00 00:00:00");
                    if (column.getDecimals() > 0) {
                        zeroValue.append(".");
                        for (int i = 0; i < column.getDecimals(); ++i) {
                            zeroValue.append("0");
                        }
                    }
                    return zeroValue.toString();
                }
                int year = buf.readUnsignedShort();
                byte month = buf.readByte();
                byte day = buf.readByte();
                byte hour = 0;
                byte minutes = 0;
                int seconds = 0;
                long microseconds = 0L;
                if (length > 4) {
                    hour = buf.readByte();
                    minutes = buf.readByte();
                    seconds = buf.readByte();
                    if (length > 7) {
                        microseconds = buf.readUnsignedInt();
                    }
                }
                LocalDateTime dateTime = LocalDateTime.of(year, month, (int)day, (int)hour, (int)minutes, seconds).plusNanos(microseconds * 1000L);
                StringBuilder microSecPattern = new StringBuilder();
                if (column.getDecimals() > 0) {
                    microSecPattern.append(".");
                    for (int i = 0; i < column.getDecimals(); ++i) {
                        microSecPattern.append("S");
                    }
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss" + microSecPattern);
                return dateTime.toLocalDate().toString() + ' ' + dateTime.toLocalTime().format(formatter);
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as String", new Object[]{column.getType()}));
                }
                return buf.readString(length);
            }
        }
        return buf.readString(length);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeByte(39);
        encoder.writeStringEscaped(maxLen == null ? value.toString() : value.toString().substring(0, maxLen.intValue()), (context.getServerStatus() & 0x200) != 0);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer writer, Object value, Calendar cal, Long maxLength) throws IOException {
        this.encodeBinaryAsString(writer, value, maxLength);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARCHAR.get();
    }
}

