/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.Column;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.plugin.Codec;
import com.singlestore.jdbc.plugin.codec.LocalDateTimeCodec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.EnumSet;

public class ZonedDateTimeCodec
implements Codec<ZonedDateTime> {
    public static final ZonedDateTimeCodec INSTANCE = new ZonedDateTimeCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.DATE, DataType.YEAR, DataType.TIMESTAMP, DataType.VARCHAR, DataType.CHAR, DataType.TIME, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return ZonedDateTime.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(ZonedDateTime.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof ZonedDateTime;
    }

    @Override
    public ZonedDateTime decodeText(ReadableByteBuf buf, int length, Column column, Calendar calParam) throws SQLDataException {
        LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeText(buf, length, column, calParam);
        if (localDateTime == null) {
            return null;
        }
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        return localDateTime.atZone(cal.getTimeZone().toZoneId());
    }

    @Override
    public ZonedDateTime decodeBinary(ReadableByteBuf buf, int length, Column column, Calendar calParam) throws SQLDataException {
        LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeBinary(buf, length, column, calParam);
        if (localDateTime == null) {
            return null;
        }
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        return localDateTime.atZone(cal.getTimeZone().toZoneId());
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar calParam, Long maxLen) throws IOException {
        ZonedDateTime zdt = (ZonedDateTime)val;
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        encoder.writeByte(39);
        encoder.writeAscii(zdt.withZoneSameInstant(cal.getTimeZone().toZoneId()).format(zdt.getNano() != 0 ? LocalDateTimeCodec.TIMESTAMP_FORMAT : LocalDateTimeCodec.TIMESTAMP_FORMAT_NO_FRACTIONAL));
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar calParam, Long maxLength) throws IOException {
        ZonedDateTime zdt = (ZonedDateTime)value;
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        ZonedDateTime convertedZdt = zdt.withZoneSameInstant(cal.getTimeZone().toZoneId());
        int nano = convertedZdt.getNano();
        if (nano > 0) {
            encoder.writeByte(11);
            encoder.writeShort((short)convertedZdt.get(ChronoField.YEAR));
            encoder.writeByte(convertedZdt.get(ChronoField.MONTH_OF_YEAR));
            encoder.writeByte(convertedZdt.get(ChronoField.DAY_OF_MONTH));
            encoder.writeByte(convertedZdt.get(ChronoField.HOUR_OF_DAY));
            encoder.writeByte(convertedZdt.get(ChronoField.MINUTE_OF_HOUR));
            encoder.writeByte(convertedZdt.get(ChronoField.SECOND_OF_MINUTE));
            encoder.writeInt(nano / 1000);
        } else {
            encoder.writeByte(7);
            encoder.writeShort((short)convertedZdt.get(ChronoField.YEAR));
            encoder.writeByte(convertedZdt.get(ChronoField.MONTH_OF_YEAR));
            encoder.writeByte(convertedZdt.get(ChronoField.DAY_OF_MONTH));
            encoder.writeByte(convertedZdt.get(ChronoField.HOUR_OF_DAY));
            encoder.writeByte(convertedZdt.get(ChronoField.MINUTE_OF_HOUR));
            encoder.writeByte(convertedZdt.get(ChronoField.SECOND_OF_MINUTE));
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }
}

