/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util.log;

import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.LoggerHelper;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;

public class ConsoleLogger
implements Logger {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss*SSSZZZZ");
    private ConsoleLoggerKey identifier;
    private final PrintStream err;
    private final PrintStream log;

    public ConsoleLogger(ConsoleLoggerKey identifier, PrintStream log, PrintStream err) {
        this.identifier = identifier;
        this.log = log == null ? System.out : log;
        this.err = err == null ? System.err : err;
    }

    public ConsoleLogger(ConsoleLoggerKey identifier) {
        this(identifier, System.out, System.err);
    }

    @Override
    public boolean printStackTrace() {
        return this.identifier.isPrintStackTrace();
    }

    @Override
    public int maxStackTraceSizeToLog() {
        return this.identifier.maxPrintStackSizeToLog();
    }

    @Override
    public String getName() {
        return this.identifier.name;
    }

    final String format(String from, Object ... arguments) {
        if (from != null) {
            String computed = from;
            for (Object argument : arguments) {
                computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(String.valueOf(argument)));
            }
            return computed;
        }
        return null;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.identifier.logLevel.getLevel() >= CONSOLE_LOG_LEVEL.TRACE.getLevel();
    }

    @Override
    public synchronized void trace(String msg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.log.format("%s [%s] TRACE %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg);
        if (this.printStackTrace()) {
            this.log.format("%s [%s] TRACE %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), LoggerHelper.currentStackTrace(this.maxStackTraceSizeToLog()));
        }
    }

    @Override
    public synchronized void trace(String format, Object ... arguments) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.log.format("%s [%s] TRACE %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), this.format(format, arguments));
        if (this.printStackTrace()) {
            this.log.format("%s [%s] TRACE %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), LoggerHelper.currentStackTrace(this.maxStackTraceSizeToLog()));
        }
    }

    @Override
    public synchronized void trace(String msg, Throwable t) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.log.format("%s [%s] TRACE %s %s - %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg, t);
        t.printStackTrace(this.log);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.identifier.logLevel.getLevel() >= CONSOLE_LOG_LEVEL.DEBUG.getLevel();
    }

    @Override
    public synchronized void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.log.format("%s [%s] DEBUG %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg);
    }

    @Override
    public synchronized void debug(String format, Object ... arguments) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.log.format("%s [%s] DEBUG %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), this.format(format, arguments));
    }

    @Override
    public synchronized void debug(String msg, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.log.format("%s [%s] DEBUG %s %s - %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg, t);
        t.printStackTrace(this.log);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.identifier.logLevel.getLevel() >= CONSOLE_LOG_LEVEL.INFO.getLevel();
    }

    @Override
    public synchronized void info(String msg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.log.format("%s [%s] INFO %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg);
    }

    @Override
    public synchronized void info(String format, Object ... arguments) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.log.format("%s [%s] INFO %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), this.format(format, arguments));
    }

    @Override
    public synchronized void info(String msg, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.log.format("%s [%s] INFO %s %s - %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg, t);
        t.printStackTrace(this.log);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.identifier.logLevel.getLevel() >= CONSOLE_LOG_LEVEL.WARN.getLevel();
    }

    @Override
    public synchronized void warn(String msg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.err.format("%s [%s] WARN %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg);
    }

    @Override
    public synchronized void warn(String format, Object ... arguments) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.err.format("%s [%s] WARN %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), this.format(format, arguments));
    }

    @Override
    public synchronized void warn(String msg, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.err.format("%s [%s] WARN %s %s - %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg, t);
        t.printStackTrace(this.err);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.identifier.logLevel.getLevel() >= CONSOLE_LOG_LEVEL.ERROR.getLevel();
    }

    @Override
    public synchronized void error(String msg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.err.format("%s [%s] ERROR %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg);
    }

    @Override
    public synchronized void error(String format, Object ... arguments) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.err.format("%s [%s] ERROR %s %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), this.format(format, arguments));
    }

    @Override
    public synchronized void error(String msg, Throwable t) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.err.format("%s [%s] ERROR %s %s - %s\n", ConsoleLogger.currentTimestamp(), Thread.currentThread().getName(), this.getName(), msg, t);
        t.printStackTrace(this.err);
    }

    private static String currentTimestamp() {
        ZonedDateTime zdt = ZonedDateTime.now();
        return zdt.format(FORMATTER);
    }

    public static final class ConsoleLoggerKey {
        private final String name;
        private final CONSOLE_LOG_LEVEL logLevel;
        private final String logFilePath;
        private final boolean printStackTrace;
        private final int maxPrintStackSizeToLog;

        public ConsoleLoggerKey(String name, CONSOLE_LOG_LEVEL logLevel, String logFilePath, boolean printStackTrace, int maxPrintStackSizeToLog) {
            this.name = name;
            this.logLevel = logLevel;
            this.logFilePath = logFilePath;
            this.printStackTrace = printStackTrace;
            this.maxPrintStackSizeToLog = maxPrintStackSizeToLog;
        }

        public boolean isPrintStackTrace() {
            return this.printStackTrace;
        }

        public int maxPrintStackSizeToLog() {
            return this.maxPrintStackSizeToLog;
        }

        public String getLogFilePath() {
            return this.logFilePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsoleLoggerKey that = (ConsoleLoggerKey)o;
            return Objects.equals(this.name, that.name) && this.logLevel == that.logLevel && Objects.equals(this.logFilePath, that.logFilePath);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.logLevel, this.logFilePath});
        }
    }

    public static enum CONSOLE_LOG_LEVEL {
        ERROR(0),
        WARN(1),
        INFO(2),
        DEBUG(3),
        TRACE(4);

        private int level;

        private CONSOLE_LOG_LEVEL(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public static CONSOLE_LOG_LEVEL fromLevelName(String name) {
            return Arrays.stream(CONSOLE_LOG_LEVEL.values()).filter(v -> v.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        }
    }
}

