/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.authentication;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.Driver;
import com.singlestore.jdbc.plugin.AuthenticationPlugin;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.ServiceLoader;

public final class AuthenticationPluginLoader {
    public static AuthenticationPlugin get(String type, Configuration conf) throws SQLException {
        ServiceLoader<AuthenticationPlugin> loader = ServiceLoader.load(AuthenticationPlugin.class, Driver.class.getClassLoader());
        String[] authList = conf.restrictedAuth() != null ? conf.restrictedAuth().split(",") : null;
        for (AuthenticationPlugin implClass : loader) {
            block4: {
                block3: {
                    if (!type.equals(implClass.type())) continue;
                    if (conf.restrictedAuth() == null) break block3;
                    if (!Arrays.stream(authList).anyMatch(type::contains)) break block4;
                }
                return implClass;
            }
            throw new SQLException(String.format("Client restrict authentication plugin to a limited set of authentication plugin and doesn't permit requested plugin ('%s'). Current list is `restrictedAuth=%s`", type, conf.restrictedAuth()), "08004", 1251);
        }
        throw new SQLException("Client does not support authentication protocol requested by server. plugin type was = '" + type + "'", "08004", 1251);
    }
}

