/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util.log;

import java.util.Arrays;
import java.util.stream.Collectors;

public final class LoggerHelper {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String hex(byte[] bytes, int offset, int dataLength) {
        return LoggerHelper.hex(bytes, offset, dataLength, Integer.MAX_VALUE);
    }

    public static String hex(byte[] bytes, int offset, int dataLength, int trunkLength) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] hexaValue = new char[16];
        hexaValue[8] = 32;
        int posHexa = 0;
        int logLength = Math.min(dataLength, trunkLength);
        StringBuilder sb = new StringBuilder(logLength * 3);
        sb.append("+--------------------------------------------------+\n|  0  1  2  3  4  5  6  7   8  9  a  b  c  d  e  f |\n+--------------------------------------------------+------------------+\n| ");
        for (int pos = offset; pos < logLength + offset; ++pos) {
            int byteValue = bytes[pos] & 0xFF;
            sb.append(hexArray[byteValue >>> 4]).append(hexArray[byteValue & 0xF]).append(" ");
            int n = hexaValue[posHexa++] = byteValue > 31 && byteValue < 127 ? (int)byteValue : 46;
            if (posHexa == 8) {
                sb.append(" ");
            }
            if (posHexa != 16) continue;
            sb.append("| ").append(hexaValue).append(" |\n");
            if (pos + 1 != logLength + offset) {
                sb.append("| ");
            }
            posHexa = 0;
        }
        int remaining = posHexa;
        if (remaining > 0) {
            if (remaining < 8) {
                while (remaining < 8) {
                    sb.append("   ");
                    ++remaining;
                }
                sb.append(" ");
            }
            while (remaining < 16) {
                sb.append("   ");
                ++remaining;
            }
            while (posHexa < 16) {
                hexaValue[posHexa] = 32;
                ++posHexa;
            }
            sb.append("| ").append(hexaValue).append(" |\n");
        }
        if (dataLength > trunkLength) {
            sb.append("+-------------------truncated----------------------+------------------+\n");
        } else {
            sb.append("+--------------------------------------------------+------------------+\n");
        }
        return sb.toString();
    }

    public static String currentStackTrace(int limit) {
        return Arrays.stream(Thread.currentThread().getStackTrace()).skip(3L).limit(limit).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
    }

    public static String hex(byte[] header, byte[] bytes, int offset, int dataLength, int trunkLength) {
        byte[] complete = new byte[dataLength + header.length];
        System.arraycopy(header, 0, complete, 0, header.length);
        System.arraycopy(bytes, offset, complete, header.length, dataLength);
        return LoggerHelper.hex(complete, 0, dataLength + header.length, trunkLength);
    }
}

