/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.message.client.QueryPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.util.ClientParser;
import com.singlestore.jdbc.util.NativeSql;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Statement
implements java.sql.Statement {
    private static final Pattern identifierPattern = Pattern.compile("[0-9a-zA-Z$_\\u0080-\\uFFFF]*", 192);
    private static final Pattern escapePattern = Pattern.compile("[\u0000'\"\b\n\r\t\u001a\\\\]");
    private static final Map<String, String> mapper = new HashMap<String, String>();
    private final Logger logger;
    private List<String> batchQueries;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected final ReentrantLock lock;
    protected final Connection con;
    protected Boolean isInsertDuplicate = null;
    protected int queryTimeout;
    protected long maxRows;
    protected String lastSql;
    protected int fetchSize;
    protected int autoGeneratedKeys;
    protected boolean closeOnCompletion;
    protected boolean closed;
    protected boolean escape;
    protected List<Completion> results;
    protected Completion currResult;
    protected InputStream localInfileInputStream;

    public Statement(Connection con, ReentrantLock lock, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        this.con = con;
        this.lock = lock;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetType = resultSetType;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.fetchSize = defaultFetchSize;
        this.logger = Loggers.getLogger(Statement.class);
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkNotClosed();
        this.localInfileInputStream = inputStream;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeInternal(sql, 2);
        this.currResult = this.results.remove(0);
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            if (this.currResult != null && this.currResult instanceof Result) {
                ((Result)this.currResult).closeFromStmtClose(this.lock);
            }
            if (this.results != null && !this.results.isEmpty()) {
                for (Completion completion : this.results) {
                    if (!(completion instanceof Result)) continue;
                    ((Result)completion).closeFromStmtClose(this.lock);
                }
            }
        }
    }

    public void abort() {
        this.lock.lock();
        try {
            if (!this.closed) {
                this.closed = true;
                if (this.currResult != null && this.currResult instanceof Result) {
                    ((Result)this.currResult).abort();
                }
                if (this.results != null) {
                    for (Completion completion : this.results) {
                        if (!(completion instanceof Result)) continue;
                        ((Result)completion).abort();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
        this.escape = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkNotClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.exceptionFactory().create("Query timeout cannot be negative : asked for " + seconds, "42000");
        }
        this.queryTimeout = seconds;
    }

    public void setNextLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkNotClosed();
        this.localInfileInputStream = inputStream;
    }

    public InputStream getNextLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkNotClosed();
        boolean locked = this.lock.tryLock();
        if (!locked) {
            this.con.cancelCurrentQuery();
        } else {
            this.lock.unlock();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.con.getContext().setWarning(0);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw this.exceptionFactory().notSupported("Cursors are not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 2);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof OkPacket) {
            return (int)((OkPacket)this.currResult).getAffectedRows();
        }
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw this.exceptionFactory().create("invalid fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (sql == null) {
            throw this.exceptionFactory().create("null cannot be set to addBatch(String sql)");
        }
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        this.batchQueries.add(this.escape ? NativeSql.parse(sql, this.con.getContext()) : sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        } else {
            this.batchQueries.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchQueries == null || this.batchQueries.isEmpty()) {
            return new int[0];
        }
        this.lock.lock();
        try {
            this.lastSql = this.batchQueries.get(0);
            this.autoGeneratedKeys = 1;
            boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
            if (possibleLoadLocal) {
                possibleLoadLocal = false;
                for (String batchQuery : this.batchQueries) {
                    String sql = batchQuery.toUpperCase(Locale.ROOT);
                    if (!sql.contains(" LOCAL ") || !sql.contains("LOAD") || !sql.contains(" INFILE")) continue;
                    possibleLoadLocal = true;
                    break;
                }
            }
            List<Completion> res = possibleLoadLocal ? this.executeInternalBatchStandard() : this.executeInternalBatchPipeline();
            this.results = res;
            int[] updates = new int[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                updates[i] = res.get(i) instanceof OkPacket ? (int)((OkPacket)res.get(i)).getAffectedRows() : -2;
            }
            this.currResult = this.results.remove(0);
            this.batchQueries.clear();
            int[] nArray = updates;
            return nArray;
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.batchQueries.clear();
            this.lock.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.con;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof ResultSet) {
            this.lock.lock();
            try {
                Result result = (Result)this.currResult;
                if (current == 1) {
                    result.close();
                } else {
                    result.fetchRemaining();
                }
                if (result.streaming() && (this.con.getContext().getServerStatus() & 8) > 0) {
                    this.con.getClient().readStreamingResults(this.results, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.results.size() > 0) {
            this.currResult = this.results.remove(0);
            return this.currResult instanceof Result;
        }
        this.currResult = null;
        return false;
    }

    public void fetchRemaining() throws SQLException {
        if (this.currResult != null && this.currResult instanceof ResultSet) {
            Result result = (Result)this.currResult;
            result.fetchRemaining();
            if (result.streaming() && (this.con.getContext().getServerStatus() & 8) > 0) {
                this.con.getClient().readStreamingResults(this.results, 0, 0L, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion);
            }
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkNotClosed();
        if (this.autoGeneratedKeys != 1) {
            throw new SQLException("Cannot return generated keys: query was not set with Statement.RETURN_GENERATED_KEYS");
        }
        ArrayList<String[]> insertIds = new ArrayList<String[]>();
        if (this.con.getContext().getConf().returnMultiValuesGeneratedIds() && !this.checkIfInsertDuplicateCommand(this.getLastSql())) {
            Iterator<Completion> ok;
            if (this.currResult instanceof OkPacket && ((OkPacket)((Object)(ok = (OkPacket)this.currResult))).getLastInsertId() != 0L) {
                insertIds.add(new String[]{String.valueOf(((OkPacket)((Object)ok)).getLastInsertId())});
                if (((OkPacket)((Object)ok)).getAffectedRows() > 1L) {
                    int i = 1;
                    while ((long)i < ((OkPacket)((Object)ok)).getAffectedRows()) {
                        insertIds.add(new String[]{String.valueOf(((OkPacket)((Object)ok)).getLastInsertId() + (long)i)});
                        ++i;
                    }
                }
            }
            if (this.results != null) {
                for (Completion result : this.results) {
                    OkPacket ok2;
                    if (!(result instanceof OkPacket) || (ok2 = (OkPacket)result).getLastInsertId() == 0L) continue;
                    insertIds.add(new String[]{String.valueOf(ok2.getLastInsertId())});
                    if (ok2.getAffectedRows() <= 1L) continue;
                    int i = 1;
                    while ((long)i < ok2.getAffectedRows()) {
                        insertIds.add(new String[]{String.valueOf(ok2.getLastInsertId() + (long)i)});
                        ++i;
                    }
                }
            }
        } else {
            if (this.currResult instanceof OkPacket && ((OkPacket)this.currResult).getLastInsertId() != 0L) {
                insertIds.add(new String[]{String.valueOf(((OkPacket)this.currResult).getLastInsertId())});
            }
            if (this.results != null) {
                for (Completion result : this.results) {
                    if (!(result instanceof OkPacket) || ((OkPacket)result).getLastInsertId() == 0L) continue;
                    insertIds.add(new String[]{String.valueOf(((OkPacket)result).getLastInsertId())});
                }
            }
        }
        if (insertIds.isEmpty()) {
            return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
        }
        String[][] ids = (String[][])insertIds.toArray((T[])new String[0][]);
        return CompleteResult.createResultSet("insert_id", DataType.BIGINT, ids, this.con.getContext(), 544, this.resultSetType);
    }

    protected boolean checkIfInsertDuplicateCommand(String sql) {
        if (this.isInsertDuplicate == null) {
            if (sql == null) {
                this.isInsertDuplicate = false;
            } else {
                ClientParser parser = ClientParser.parameterParts(sql, (this.con.getContext().getServerStatus() & 0x200) > 0);
                this.isInsertDuplicate = parser.isInsertDuplicate();
            }
        }
        return this.isInsertDuplicate;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeInternal(sql, autoGeneratedKeys);
        this.currResult = this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return (int)((OkPacket)this.currResult).getAffectedRows();
    }

    private void executeInternal(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        this.lock.lock();
        try {
            this.lastSql = sql;
            this.autoGeneratedKeys = autoGeneratedKeys;
            String cmd = this.escapeTimeout(sql);
            this.results = this.con.getClient().execute(new QueryPacket(cmd, this.localInfileInputStream), this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
            this.lock.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeInternal(sql, autoGeneratedKeys);
        this.currResult = this.results.remove(0);
        return this.currResult instanceof Result;
    }

    protected String escapeTimeout(String sql) throws SQLException {
        return this.escape ? NativeSql.parse(sql, this.con.getContext()) : sql;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        Result res;
        this.checkNotClosed();
        this.closeOnCompletion = true;
        if (this.results != null && this.results.size() > 0) {
            for (int i = this.results.size(); i > 0; --i) {
                Completion completion = this.results.get(i - 1);
                if (!(completion instanceof Result)) continue;
                ((Result)completion).closeOnCompletion();
                return;
            }
        } else if (this.currResult != null && this.currResult instanceof ResultSet && ((res = (Result)this.currResult).streaming() || res.loaded())) {
            res.closeOnCompletion();
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkNotClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw this.exceptionFactory().create("The receiver is not a wrapper and does not implement the interface", "42000");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        if (iface == null) {
            return false;
        }
        return iface.isInstance(this);
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw this.exceptionFactory().create("Cannot do an operation on a closed statement");
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeLargeUpdate(sql, 2);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeInternal(sql, autoGeneratedKeys);
        this.currResult = this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkNotClosed();
        this.logger.warn("Setting maximum rows via setMaxRows() or setLargeMaxRows() is not supported. Please use the LIMIT <max> syntax in your SELECT query.\nRefer to https://docs.singlestore.com/db/latest/en/reference/sql-reference/data-manipulation-language-dml/select.html for more information");
        if (max < 0L) {
            throw this.exceptionFactory().create("max rows cannot be negative : asked for " + max, "42000");
        }
        this.maxRows = max;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof OkPacket) {
            return (int)((OkPacket)this.currResult).getAffectedRows();
        }
        return -1L;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchQueries == null || this.batchQueries.isEmpty()) {
            return new long[0];
        }
        this.lock.lock();
        try {
            this.lastSql = this.batchQueries.get(0);
            this.autoGeneratedKeys = 1;
            boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
            if (possibleLoadLocal) {
                possibleLoadLocal = false;
                for (String batchQuery : this.batchQueries) {
                    String sql = batchQuery.toUpperCase(Locale.ROOT);
                    if (!sql.contains(" LOCAL ") || !sql.contains("LOAD") || !sql.contains(" INFILE")) continue;
                    possibleLoadLocal = true;
                    break;
                }
            }
            List<Completion> res = possibleLoadLocal ? this.executeInternalBatchStandard() : this.executeInternalBatchPipeline();
            this.results = res;
            long[] updates = new long[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                updates[i] = ((OkPacket)res.get(i)).getAffectedRows();
            }
            this.currResult = this.results.remove(0);
            this.batchQueries.clear();
            long[] lArray = updates;
            return lArray;
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.batchQueries.clear();
            this.lock.unlock();
        }
    }

    private List<Completion> executeInternalBatchPipeline() throws SQLException {
        ClientMessage[] packets = new QueryPacket[this.batchQueries.size()];
        for (int i = 0; i < this.batchQueries.size(); ++i) {
            String sql = this.batchQueries.get(i);
            packets[i] = new QueryPacket(sql);
        }
        return this.con.getClient().executePipeline(packets, this, 0, 0L, 1007, 1003, this.closeOnCompletion, false);
    }

    private List<Completion> executeInternalBatchStandard() throws SQLException {
        ArrayList<Completion> results = new ArrayList<Completion>();
        try {
            for (int i = 0; i < this.batchQueries.size(); ++i) {
                results.addAll(this.con.getClient().execute(new QueryPacket(this.batchQueries.get(i), this.localInfileInputStream), this, 0, 0L, 1007, 1003, this.closeOnCompletion, false));
            }
            ArrayList<Completion> i = results;
            return i;
        }
        catch (SQLException sqle) {
            int[] updateCounts = new int[this.batchQueries.size()];
            for (int i = 0; i < Math.min(results.size(), updateCounts.length); ++i) {
                Completion completion = (Completion)results.get(i);
                updateCounts[i] = completion instanceof OkPacket ? (int)((OkPacket)completion).getAffectedRows() : 0;
            }
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), updateCounts, (Throwable)sqle);
        }
        finally {
            this.localInfileInputStream = null;
        }
    }

    @Override
    public String enquoteLiteral(String val) {
        Matcher matcher = escapePattern.matcher(val);
        StringBuffer escapedVal = new StringBuffer("'");
        while (matcher.find()) {
            matcher.appendReplacement(escapedVal, mapper.get(matcher.group()));
        }
        matcher.appendTail(escapedVal);
        escapedVal.append("'");
        return escapedVal.toString();
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        if (this.isSimpleIdentifier(identifier)) {
            return alwaysQuote ? "`" + identifier + "`" : identifier;
        }
        if (identifier.contains("\u0000")) {
            throw this.exceptionFactory().create("Invalid name - containing u0000 character", "42000");
        }
        if (identifier.matches("^`.+`$")) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        return "`" + identifier.replace("`", "``") + "`";
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) {
        return identifier != null && !identifier.isEmpty() && identifierPattern.matcher(identifier).matches();
    }

    public String getLastSql() {
        return this.lastSql;
    }

    @Override
    public String enquoteNCharLiteral(String val) {
        return "N'" + val.replace("'", "''") + "'";
    }

    static {
        mapper.put("\u0000", "\\0");
        mapper.put("'", "\\\\'");
        mapper.put("\"", "\\\\\"");
        mapper.put("\b", "\\\\b");
        mapper.put("\n", "\\\\n");
        mapper.put("\r", "\\\\r");
        mapper.put("\t", "\\\\t");
        mapper.put("\u001a", "\\\\Z");
        mapper.put("\\", "\\\\");
    }
}

