/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.client;

import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.codec.Parameter;
import com.singlestore.jdbc.message.client.RedoableClientMessage;
import com.singlestore.jdbc.plugin.codec.ByteArrayCodec;
import com.singlestore.jdbc.util.ClientParser;
import java.io.IOException;
import java.sql.SQLException;

public class RewriteQueryMultiPacket
implements RedoableClientMessage {
    private static final int PARAMETER_LENGTH = 1024;
    private final ClientParser parser;
    private Parameters parameters;
    private final int paramCount;

    public RewriteQueryMultiPacket(int paramCount, ClientParser parser, Parameters parameters) {
        this.paramCount = paramCount;
        this.parser = parser;
        this.parameters = parameters;
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            com.singlestore.jdbc.client.util.Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            this.parameters.set(i, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
        }
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public int encode(Writer encoder, Context context) throws IOException, SQLException {
        int packetsSize = 0;
        encoder.initPacket();
        encoder.writeByte(3);
        if (this.parser.getParamPositions().size() == 0) {
            encoder.writeBytes(this.parser.getQuery());
        } else {
            int pos = 0;
            int lastParamPos = this.parser.getParamPositions().get(this.parser.getParamPositions().size() - 1) + 1;
            int paramPosIdx = 0;
            for (int i = 0; i < this.parser.getParamPositions().size(); ++i) {
                if (encoder.throwMaxAllowedLength(encoder.pos() + this.paramCount * 1024) && paramPosIdx != 0 && paramPosIdx % this.paramCount == 0) {
                    encoder.writeBytes(this.parser.getQuery(), lastParamPos, this.parser.getQuery().length - lastParamPos);
                    encoder.flush();
                    ++packetsSize;
                    encoder.initPacket();
                    encoder.writeByte(3);
                    pos = 0;
                    paramPosIdx = 0;
                }
                int paramPos = this.parser.getParamPositions().get(paramPosIdx);
                encoder.writeBytes(this.parser.getQuery(), pos, paramPos - pos);
                pos = paramPos + 1;
                this.parameters.get(i).encodeText(encoder, context);
                ++paramPosIdx;
            }
            encoder.writeBytes(this.parser.getQuery(), lastParamPos, this.parser.getQuery().length - lastParamPos);
        }
        encoder.flush();
        return ++packetsSize;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String description() {
        return this.parser.getSql();
    }
}

