/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;

public class BigDecimalCodec
implements Codec<BigDecimal> {
    public static final BigDecimalCodec INSTANCE = new BigDecimalCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INT, DataType.FLOAT, DataType.DOUBLE, DataType.BIGINT, DataType.BIT, DataType.DECIMAL, DataType.OLDDECIMAL, DataType.YEAR, DataType.DECIMAL, DataType.VARCHAR, DataType.CHAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return BigDecimal.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(BigDecimal.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public BigDecimal decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case YEAR: {
                return new BigDecimal(buf.readAscii(length.get()));
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length.get());
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as BigDecimal", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case CHAR: {
                String str = buf.readString(length.get());
                try {
                    return new BigDecimal(str);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as BigDecimal", str));
                }
            }
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length.get(); ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return BigDecimal.valueOf(result);
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as BigDecimal", new Object[]{column.getType()}));
    }

    @Override
    public BigDecimal decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: {
                if (!column.isSigned()) {
                    return BigDecimal.valueOf(buf.readUnsignedByte());
                }
                return BigDecimal.valueOf(buf.readByte());
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return BigDecimal.valueOf(buf.readUnsignedShort());
                }
                return BigDecimal.valueOf(buf.readShort());
            }
            case MEDIUMINT: {
                if (!column.isSigned()) {
                    int val = buf.readUnsignedMedium();
                    buf.skip();
                    return BigDecimal.valueOf(val);
                }
                return BigDecimal.valueOf(buf.readInt());
            }
            case INT: {
                if (!column.isSigned()) {
                    return BigDecimal.valueOf(buf.readUnsignedInt());
                }
                return BigDecimal.valueOf(buf.readInt());
            }
            case BIGINT: {
                BigInteger val;
                if (column.isSigned()) {
                    val = BigInteger.valueOf(buf.readLong());
                } else {
                    byte[] bb = new byte[8];
                    for (int i = 7; i >= 0; --i) {
                        bb[i] = buf.readByte();
                    }
                    val = new BigInteger(1, bb);
                }
                return new BigDecimal(String.valueOf(val)).setScale(column.getDecimals());
            }
            case FLOAT: {
                return BigDecimal.valueOf(buf.readFloat());
            }
            case DOUBLE: {
                return BigDecimal.valueOf(buf.readDouble());
            }
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length.get(); ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return BigDecimal.valueOf(result);
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length.get());
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as BigDecimal", new Object[]{column.getType()}));
                }
            }
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARCHAR: 
            case CHAR: {
                String str = buf.readString(length.get());
                try {
                    return new BigDecimal(str);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as BigDecimal", str));
                }
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as BigDecimal", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long length) throws IOException {
        encoder.writeAscii(((BigDecimal)value).toPlainString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        String asciiFormat = ((BigDecimal)value).toPlainString();
        encoder.writeLength(asciiFormat.length());
        encoder.writeAscii(asciiFormat);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DECIMAL.get();
    }
}

