/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;

public class BigIntegerCodec
implements Codec<BigInteger> {
    public static final BigIntegerCodec INSTANCE = new BigIntegerCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INT, DataType.BIGINT, DataType.DECIMAL, DataType.YEAR, DataType.DOUBLE, DataType.DECIMAL, DataType.OLDDECIMAL, DataType.FLOAT, DataType.BIT, DataType.VARCHAR, DataType.CHAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return BigInteger.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(BigInteger.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigInteger;
    }

    @Override
    public BigInteger decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case OLDDECIMAL: {
                return new BigDecimal(buf.readAscii(length.get())).toBigInteger();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length.get());
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as BigInteger", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case CHAR: {
                String str2 = buf.readString(length.get());
                try {
                    return new BigDecimal(str2).toBigInteger();
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as BigInteger", str2));
                }
            }
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length.get(); ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return BigInteger.valueOf(result);
            }
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INT: 
            case BIGINT: 
            case YEAR: {
                return new BigInteger(buf.readAscii(length.get()));
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as BigInteger", new Object[]{column.getType()}));
    }

    @Override
    public BigInteger decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length.get(); ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return BigInteger.valueOf(result);
            }
            case TINYINT: {
                if (!column.isSigned()) {
                    return BigInteger.valueOf(buf.readUnsignedByte());
                }
                return BigInteger.valueOf(buf.readByte());
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return BigInteger.valueOf(buf.readUnsignedShort());
                }
                return BigInteger.valueOf(buf.readShort());
            }
            case MEDIUMINT: {
                if (!column.isSigned()) {
                    int val = buf.readUnsignedMedium();
                    buf.skip();
                    return BigInteger.valueOf(val);
                }
                return BigInteger.valueOf(buf.readInt());
            }
            case INT: {
                if (!column.isSigned()) {
                    return BigInteger.valueOf(buf.readUnsignedInt());
                }
                return BigInteger.valueOf(buf.readInt());
            }
            case FLOAT: {
                return BigDecimal.valueOf(buf.readFloat()).toBigInteger();
            }
            case DOUBLE: {
                return BigDecimal.valueOf(buf.readDouble()).toBigInteger();
            }
            case DECIMAL: {
                return new BigDecimal(buf.readAscii(length.get())).toBigInteger();
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return BigInteger.valueOf(buf.readLong());
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                return new BigInteger(1, bb);
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length.get());
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as BigInteger", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case CHAR: {
                String str = buf.readString(length.get());
                try {
                    return new BigInteger(str);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as BigInteger", str));
                }
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as BigInteger", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long length) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        String asciiFormat = value.toString();
        encoder.writeLength(asciiFormat.length());
        encoder.writeAscii(asciiFormat);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DECIMAL.get();
    }
}

