/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.UUID;

public class UuidCodec
implements Codec<UUID> {
    public static final UuidCodec INSTANCE = new UuidCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, DataType.CHAR);

    @Override
    public String className() {
        return UUID.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(UUID.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof UUID;
    }

    @Override
    public UUID decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        String val = buf.readString(length.get());
        try {
            return UUID.fromString(val);
        }
        catch (Throwable throwable) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as UUID", new Object[]{val, column.getType()}));
        }
    }

    @Override
    public UUID decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        String val = buf.readString(length.get());
        try {
            return UUID.fromString(val);
        }
        catch (Throwable throwable) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as UUID", new Object[]{val, column.getType()}));
        }
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long length) throws IOException {
        encoder.writeByte(39);
        encoder.writeAscii(value.toString());
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long length) throws IOException {
        String valueSt = value.toString();
        encoder.writeLength(valueSt.length());
        encoder.writeAscii(valueSt);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARCHAR.get();
    }
}

