/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.client;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.Parameter;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.message.client.RedoableClientMessage;
import com.singlestore.jdbc.util.RewriteClientParser;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RewriteQueryMultiPacket
implements RedoableClientMessage {
    private final Configuration config;
    private final RewriteClientParser parser;
    private List<Parameters> batchParameters;
    private final int paramCount;

    public RewriteQueryMultiPacket(Configuration config, int paramCount, RewriteClientParser parser, List<Parameters> batchParameters) {
        this.config = config;
        this.paramCount = paramCount;
        this.parser = parser;
        this.batchParameters = batchParameters;
    }

    @Override
    public void ensureReplayable(Context context) {
    }

    @Override
    public void saveParameters() {
        ArrayList<Parameters> clonedBatches = new ArrayList<Parameters>();
        for (Parameters parameters : this.batchParameters) {
            clonedBatches.add(parameters.clone());
        }
        this.batchParameters = clonedBatches;
    }

    @Override
    public int encode(Writer encoder, Context context) throws IOException, SQLException {
        int packetsSize = 0;
        int currentIndex = 0;
        int totalParameterList = this.batchParameters.size();
        do {
            currentIndex = this.sendRewriteCmd(encoder, context, currentIndex);
            ++packetsSize;
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new SQLException("Interrupted during batch", "70", -1);
        } while (currentIndex < totalParameterList);
        return packetsSize;
    }

    private int sendRewriteCmd(Writer encoder, Context context, int currentIndex) throws IOException, SQLException {
        int i;
        int batchIndex = currentIndex;
        encoder.initPacket();
        encoder.writeByte(3);
        Parameters parameters = this.batchParameters.get(batchIndex++);
        List<byte[]> queryParts = this.parser.getQueryParts();
        byte[] firstPart = queryParts.get(0);
        byte[] secondPart = queryParts.get(1);
        encoder.writeBytes(firstPart, 0, firstPart.length);
        encoder.writeBytes(secondPart, 0, secondPart.length);
        int packetLength = this.parser.getQueryPartsLength() + this.getApproximateParametersLength(parameters);
        for (i = 0; i < this.paramCount; ++i) {
            parameters.get(i).encodeText(encoder, context);
            encoder.writeBytes(queryParts.get(i + 2));
        }
        if (this.parser.isQueryMultiValuesRewritable()) {
            Loggers.getLogger(RewriteQueryMultiPacket.class).debug("execute multi values rewrite batch query");
            while (batchIndex < this.batchParameters.size()) {
                parameters = this.batchParameters.get(batchIndex);
                if (!encoder.throwMaxAllowedLength(packetLength += this.getApproximateParametersLength(parameters))) {
                    encoder.writeByte(44);
                    encoder.writeBytes(secondPart, 0, secondPart.length);
                    for (i = 0; i < this.paramCount; ++i) {
                        parameters.get(i).encodeText(encoder, context);
                        byte[] addPart = queryParts.get(i + 2);
                        encoder.writeBytes(addPart, 0, addPart.length);
                    }
                    ++batchIndex;
                    continue;
                }
                Loggers.getLogger(RewriteQueryMultiPacket.class).debug("split multi values rewrite batch query on {} batch with size {}", batchIndex, packetLength);
                break;
            }
            encoder.writeBytes(queryParts.get(this.paramCount + 2));
        } else {
            encoder.writeBytes(queryParts.get(this.paramCount + 2));
            while (batchIndex < this.batchParameters.size() && this.config.allowMultiQueries()) {
                parameters = this.batchParameters.get(batchIndex);
                if (!encoder.throwMaxAllowedLength(packetLength += this.getApproximateParametersLength(parameters) + this.parser.getQueryPartsLength() + 1)) {
                    encoder.writeByte(59);
                    encoder.writeBytes(firstPart, 0, firstPart.length);
                    encoder.writeBytes(secondPart, 0, secondPart.length);
                    for (i = 0; i < this.paramCount; ++i) {
                        parameters.get(i).encodeText(encoder, context);
                        encoder.writeBytes(queryParts.get(i + 2));
                    }
                    encoder.writeBytes(queryParts.get(this.paramCount + 2));
                    ++batchIndex;
                    continue;
                }
                Loggers.getLogger(RewriteQueryMultiPacket.class).debug("split  multi queries command on {} batch with size {}", batchIndex, packetLength);
                break;
            }
        }
        encoder.flush();
        return batchIndex;
    }

    private int getApproximateParametersLength(Parameters parameters) throws IOException, SQLException {
        int parameterLength = 0;
        for (int i = 0; i < this.paramCount; ++i) {
            Parameter parameter = parameters.get(i);
            int paramSize = parameter.getApproximateTextProtocolLength();
            if (paramSize == -1) {
                return 1024;
            }
            parameterLength += paramSize;
        }
        return parameterLength;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String description() {
        return this.parser.getSql();
    }
}

