/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.util.Version;
import com.singlestore.jdbc.util.VersionFactory;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    public static final String DRIVER_NAME = "SingleStore JDBC";
    private final Connection connection;
    private final Configuration conf;
    private Version version;
    private Version singleStoreVersion;

    public DatabaseMetaData(Connection connection, Configuration conf) {
        this.connection = connection;
        this.conf = conf;
        this.version = null;
        this.singleStoreVersion = null;
    }

    private static String DataTypeClause(Configuration conf) {
        String upperCaseWithoutPersisted = "UCASE(IF( UCASE(COLUMN_TYPE) LIKE '%PERSISTED%', SUBSTRING(COLUMN_TYPE, 10 + LOCATE('PERSISTED', UCASE(COLUMN_TYPE))), COLUMN_TYPE))";
        String upperCaseWithoutSize = " UCASE(IF( " + upperCaseWithoutPersisted + " LIKE '%(%)%', CONCAT(SUBSTRING( " + upperCaseWithoutPersisted + ",1, LOCATE('('," + upperCaseWithoutPersisted + ") - 1 ), SUBSTRING(" + upperCaseWithoutPersisted + " ,1+locate(')', " + upperCaseWithoutPersisted + "))), " + upperCaseWithoutPersisted + "))";
        if (conf.tinyInt1isBit()) {
            upperCaseWithoutSize = " IF(COLUMN_TYPE like 'tinyint%', '" + (conf.transformedBitIsBoolean() ? "BOOLEAN" : "BIT") + "', " + upperCaseWithoutSize + ")";
        }
        if (!conf.yearIsDateType()) {
            return " IF(c.COLUMN_TYPE IN ('year(2)', 'year(4)'), 'SMALLINT', " + upperCaseWithoutSize + ")";
        }
        return upperCaseWithoutSize;
    }

    private static String DateTimeSizeClause(String fullTypeColumnName) {
        return "  WHEN 'time' THEN IF(" + fullTypeColumnName + " like 'time(6)%',17,10)  WHEN 'date' THEN 10  WHEN 'datetime' THEN IF(" + fullTypeColumnName + " like 'datetime(6)%',26,19)  WHEN 'timestamp' THEN IF(" + fullTypeColumnName + " like 'timestamp(6)%',26,19)";
    }

    private static String DateTimeScaleClause(String fullTypeColumnName) {
        return "  WHEN 'time' THEN IF(" + fullTypeColumnName + " like 'time(6)%',6,0)  WHEN 'datetime' THEN IF(" + fullTypeColumnName + " like 'datetime(6)%',6,0)  WHEN 'timestamp' THEN IF(" + fullTypeColumnName + " like 'timestamp(6)%',6,0)";
    }

    public Version getVersion() throws SQLException {
        return this.conf.useMysqlVersion() ? this.getMySQLVersion() : this.getSingleStoreVersion();
    }

    public Version getSingleStoreVersion() throws SQLException {
        if (this.singleStoreVersion == null) {
            String sql = "SELECT @@memsql_version;";
            ResultSet rs = this.executeQuery(sql);
            rs.next();
            this.singleStoreVersion = new Version(rs.getString(1));
        }
        return this.singleStoreVersion;
    }

    private Version getMySQLVersion() throws SQLException {
        if (this.version == null) {
            String sql = "SELECT @@version;";
            ResultSet rs = this.executeQuery(sql);
            rs.next();
            this.version = new Version(rs.getString(1));
        }
        return this.version;
    }

    private ResultSet executeQuery(String sql) throws SQLException {
        Statement stmt = this.connection.createStatement(1004, 1007);
        CompleteResult rs = (CompleteResult)stmt.executeQuery(sql);
        rs.setStatement(null);
        rs.useAliasAsName();
        return rs;
    }

    private String functionReturnTypeClause() {
        return " CASE PARAMETER_MODE   WHEN 'IN' THEN 1  ELSE 4 END";
    }

    private String procedureReturnTypeClause() {
        return " CASE PARAMETER_MODE   WHEN 'IN' THEN 1  ELSE 2 END";
    }

    private String parameterClause(boolean isProcedure, String catColumn, String columnName, String columnType, String ordinal) {
        String type = isProcedure ? "PROCEDURE" : "FUNCTION";
        return "SELECT " + catColumn + " `" + type + "_CAT`, NULL `" + type + "_SCHEM`, SPECIFIC_NAME " + type + "_NAME," + columnName + " COLUMN_NAME, " + columnType + " COLUMN_TYPE," + this.dataTypeClause("DTD_IDENTIFIER", "") + " DATA_TYPE,DATA_TYPE TYPE_NAME, CASE DATA_TYPE" + DatabaseMetaData.DateTimeSizeClause("DTD_IDENTIFIER") + "  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), NUMERIC_PRECISION)  END `PRECISION`, CASE DATA_TYPE" + DatabaseMetaData.DateTimeSizeClause("DTD_IDENTIFIER") + "  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), NUMERIC_PRECISION)  END `LENGTH`,CASE DATA_TYPE " + DatabaseMetaData.DateTimeScaleClause("DTD_IDENTIFIER") + " ELSE NUMERIC_SCALE END `SCALE`,10 RADIX," + 2 + " NULLABLE,NULL REMARKS," + (isProcedure ? "NULL COLUMN_DEF,0 SQL_DATA_TYPE,0 SQL_DATETIME_SUB," : "") + "CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH ," + ordinal + " ORDINAL_POSITION, '' IS_NULLABLE, SPECIFIC_NAME ";
    }

    public static String escapeString(String value, boolean noBackslashEscapes) {
        if (noBackslashEscapes) {
            return value.replace("'", "''");
        }
        return value.replace("\\", "\\\\").replace("'", "\\'").replace("\u0000", "\\0").replace("\"", "\\\"");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return CompleteResult.createResultSet(new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new DataType[]{DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.BIGINT, DataType.BIGINT, DataType.BIGINT, DataType.VARCHAR, DataType.VARCHAR, DataType.BIGINT}, (String[][])new String[0][], this.connection.getContext(), 0, 1003);
    }

    private String dataTypeClause(String fullTypeColumnName, String tableAlias) {
        return " CASE " + tableAlias + "DATA_TYPE WHEN 'bit' THEN " + -7 + " WHEN 'tinyblob' THEN " + -3 + " WHEN 'mediumblob' THEN " + -4 + " WHEN 'longblob' THEN " + -4 + " WHEN 'blob' THEN " + -4 + " WHEN 'tinytext' THEN  IF( " + tableAlias + "CHARACTER_SET_NAME LIKE 'binary', " + -3 + ", " + 12 + ") WHEN 'mediumtext' THEN  IF( " + tableAlias + "CHARACTER_SET_NAME LIKE 'binary', " + -4 + ", " + -1 + ") WHEN 'longtext' THEN  IF( " + tableAlias + "CHARACTER_SET_NAME LIKE 'binary', " + -4 + ", " + -1 + ") WHEN 'text' THEN  IF( " + tableAlias + "CHARACTER_SET_NAME LIKE 'binary', " + -4 + ", " + -1 + ") WHEN 'json' THEN " + -1 + " WHEN 'date' THEN " + 91 + " WHEN 'datetime' THEN " + 93 + " WHEN 'decimal' THEN " + 3 + " WHEN 'double' THEN " + 8 + " WHEN 'enum' THEN " + 12 + " WHEN 'float' THEN " + 7 + " WHEN 'int' THEN IF( " + tableAlias + fullTypeColumnName + " like '%unsigned%', " + 4 + "," + 4 + ") WHEN 'bigint' THEN " + -5 + " WHEN 'mediumint' THEN " + 4 + " WHEN 'null' THEN " + 0 + " WHEN 'set' THEN " + 12 + " WHEN 'smallint' THEN IF( " + tableAlias + fullTypeColumnName + " like '%unsigned%', " + 5 + "," + 5 + ") WHEN 'varchar' THEN  IF( " + tableAlias + "CHARACTER_SET_NAME LIKE 'binary', " + -3 + ", " + 12 + ") WHEN 'varbinary' THEN " + -3 + " WHEN 'char' THEN " + 1 + " WHEN 'binary' THEN " + -2 + " WHEN 'time' THEN " + 92 + " WHEN 'timestamp' THEN " + 93 + " WHEN 'tinyint' THEN " + (this.conf.tinyInt1isBit() ? "IF(" + tableAlias + fullTypeColumnName + " like 'tinyint%'," + (this.conf.transformedBitIsBoolean() ? 16 : -7) + "," + -6 + ") " : Integer.valueOf(-6)) + " WHEN 'year' THEN " + (this.conf.yearIsDateType() ? 91 : 5) + " ELSE " + 1111 + " END ";
    }

    private String escapeQuote(String value) {
        return "'" + DatabaseMetaData.escapeString(value, (this.connection.getContext().getServerStatus() & 0x200) > 0) + "'";
    }

    private String tableEscapeQuote(String value) throws SQLException {
        String escapedValue = "'" + DatabaseMetaData.escapeString(value, (this.connection.getContext().getServerStatus() & 0x200) > 0) + "'";
        return this.supportsMixedCaseIdentifiers() ? escapedValue : "LOWER(" + escapedValue + ")";
    }

    private String catalogCond(String columnName, String catalog) {
        if (catalog == null || catalog.isEmpty()) {
            return "(ISNULL(database()) OR (" + columnName + " = database()))";
        }
        return "(" + columnName + " = " + this.escapeQuote(catalog) + ")";
    }

    private String patternCond(String columnName, String columnValue) {
        if (columnValue == null) {
            return "";
        }
        String predicate = columnValue.indexOf(37) == -1 && columnValue.indexOf(95) == -1 ? "=" : "LIKE";
        return " AND " + columnName + " " + predicate + " '" + DatabaseMetaData.escapeString(columnValue, (this.connection.getContext().getServerStatus() & 0x200) != 0) + "' ";
    }

    private String tablePatternCond(String columnName, String tableNameValue) throws SQLException {
        if (tableNameValue == null) {
            return "";
        }
        String predicate = tableNameValue.indexOf(37) == -1 && tableNameValue.indexOf(95) == -1 ? "=" : "LIKE";
        columnName = this.supportsMixedCaseIdentifiers() ? columnName : "LOWER(" + columnName + ")";
        String escapedTableName = "'" + DatabaseMetaData.escapeString(tableNameValue, (this.connection.getContext().getServerStatus() & 0x200) != 0) + "'";
        String value = this.supportsMixedCaseIdentifiers() ? escapedTableName : "LOWER(" + escapedTableName + ")";
        return " AND " + columnName + " " + predicate + " " + value + " ";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT DISTINCT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, SEQ_IN_INDEX KEY_SEQ, INDEX_NAME PK_NAME  FROM INFORMATION_SCHEMA.STATISTICS WHERE INDEX_NAME='PRIMARY'  AND " + this.catalogCond("TABLE_SCHEMA", catalog) + this.tablePatternCond("TABLE_NAME", table) + " ORDER BY COLUMN_NAME";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean canUseFlags = this.getSingleStoreVersion().versionGreaterOrEqual(7, 8, 1);
        StringBuilder sql = new StringBuilder("SELECT TABLE_SCHEMA TABLE_CAT, NULL  TABLE_SCHEM,  TABLE_NAME, (CASE WHEN TABLE_TYPE = 'BASE TABLE' THEN 'TABLE' WHEN TABLE_TYPE = 'SYSTEM VIEW' THEN 'VIEW' ELSE TABLE_TYPE END) AS TABLE_TYPE, TABLE_COMMENT REMARKS, NULL TYPE_CAT, NULL TYPE_SCHEM, NULL TYPE_NAME, NULL SELF_REFERENCING_COL_NAME,  NULL REF_GENERATION FROM INFORMATION_SCHEMA.TABLES " + (canUseFlags ? "" : "LEFT JOIN INFORMATION_SCHEMA.ROUTINES ON (TABLE_NAME=ROUTINE_NAME AND TABLE_SCHEMA=ROUTINE_SCHEMA)") + " WHERE " + (canUseFlags ? "CAST(FLAGS AS UNSIGNED INTEGER) & 1 = 0 AND " : "ROUTINE_NAME IS NULL AND ") + this.catalogCond("TABLE_SCHEMA", catalog) + this.tablePatternCond("TABLE_NAME", tableNamePattern));
        if (types != null && types.length > 0) {
            boolean mustAddType = false;
            StringBuilder sqlType = new StringBuilder(" AND TABLE_TYPE IN (");
            for (int i = 0; i < types.length; ++i) {
                if (mustAddType) {
                    sqlType.append(",");
                }
                mustAddType = true;
                if (types[i] == null) {
                    mustAddType = false;
                    continue;
                }
                if ("information_schema".equalsIgnoreCase(catalog) && "VIEW".equals(types[i])) {
                    sqlType.append("'SYSTEM VIEW'");
                    continue;
                }
                String type = "TABLE".equals(types[i]) ? "'BASE TABLE'" : this.escapeQuote(types[i]);
                sqlType.append(type);
            }
            sqlType.append(")");
            if (mustAddType) {
                sql.append((CharSequence)sqlType);
            }
        }
        sql.append(" ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
        return this.executeQuery(sql.toString());
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String fullTypeColumnName = "COLUMN_TYPE";
        boolean canUseFlags = this.getSingleStoreVersion().versionGreaterOrEqual(7, 8, 1);
        String sql = "SELECT c.TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, c.TABLE_NAME TABLE_NAME, c.COLUMN_NAME COLUMN_NAME," + this.dataTypeClause(fullTypeColumnName, "c.") + " DATA_TYPE," + DatabaseMetaData.DataTypeClause(this.conf) + " TYPE_NAME,  CASE c.DATA_TYPE" + DatabaseMetaData.DateTimeSizeClause(fullTypeColumnName) + (this.conf.yearIsDateType() ? "" : " WHEN 'year' THEN 5") + "  ELSE   IF(c.NUMERIC_PRECISION IS NULL, LEAST(c.CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), c.NUMERIC_PRECISION)  END COLUMN_SIZE, 65535 BUFFER_LENGTH,  CONVERT (CASE c.DATA_TYPE WHEN 'year' THEN " + (this.conf.yearIsDateType() ? "c.NUMERIC_SCALE" : "0") + " WHEN 'tinyint' THEN " + (this.conf.tinyInt1isBit() ? "0" : "c.NUMERIC_SCALE") + " ELSE c.NUMERIC_SCALE END, UNSIGNED INTEGER) DECIMAL_DIGITS, 10 NUM_PREC_RADIX, IF(c.IS_NULLABLE = 'yes',1,0) NULLABLE,c.COLUMN_COMMENT REMARKS, c.COLUMN_DEFAULT COLUMN_DEF, 0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB,   LEAST(c.CHARACTER_OCTET_LENGTH," + Integer.MAX_VALUE + ") CHAR_OCTET_LENGTH, c.ORDINAL_POSITION ORDINAL_POSITION, c.IS_NULLABLE IS_NULLABLE, NULL SCOPE_CATALOG, NULL SCOPE_SCHEMA, NULL SCOPE_TABLE, NULL SOURCE_DATA_TYPE, IF(c.EXTRA = 'auto_increment','YES','NO') IS_AUTOINCREMENT,  IF(c.EXTRA in ('VIRTUAL', 'PERSISTENT', 'VIRTUAL GENERATED', 'STORED GENERATED', 'COMPUTED') ,'YES','NO') IS_GENERATEDCOLUMN  FROM INFORMATION_SCHEMA.COLUMNS c " + (canUseFlags ? "LEFT JOIN INFORMATION_SCHEMA.TABLES AS t ON (c.TABLE_NAME=t.TABLE_NAME AND c.TABLE_SCHEMA=t.TABLE_SCHEMA)" : "LEFT JOIN INFORMATION_SCHEMA.ROUTINES AS r ON (c.TABLE_NAME=r.ROUTINE_NAME AND c.TABLE_SCHEMA=r.ROUTINE_SCHEMA)") + " WHERE " + (canUseFlags ? "CAST(t.FLAGS AS UNSIGNED INTEGER) & 1 = 0 AND " : "r.ROUTINE_NAME IS NULL AND ") + this.catalogCond("c.TABLE_SCHEMA", catalog) + this.tablePatternCond("c.TABLE_NAME", tableNamePattern) + this.patternCond("c.COLUMN_NAME", columnNamePattern) + " ORDER BY TABLE_CAT, TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("SingleStore does not support foreign keys and referential integrity");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter cannot be null in getBestRowIdentifier()");
        }
        StringBuilder sbInner = new StringBuilder("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE COLUMN_KEY = 'PRI'");
        sbInner.append(" AND ").append(this.catalogCond("TABLE_SCHEMA", catalog));
        sbInner.append(" AND TABLE_NAME = ").append(this.escapeQuote(table));
        StringBuilder sb = new StringBuilder("SELECT 2 SCOPE, COLUMN_NAME," + this.dataTypeClause("COLUMN_TYPE", "") + " DATA_TYPE, DATA_TYPE TYPE_NAME, IF(NUMERIC_PRECISION IS NULL, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION) COLUMN_SIZE, 0 BUFFER_LENGTH, NUMERIC_SCALE DECIMAL_DIGITS," + 1 + " PSEUDO_COLUMN FROM INFORMATION_SCHEMA.COLUMNS WHERE (COLUMN_KEY  = 'PRI' OR (COLUMN_KEY = 'UNI' AND NOT EXISTS (" + sbInner + " )))");
        sb.append(" AND ").append(this.catalogCond("TABLE_SCHEMA", catalog));
        sb.append(" AND TABLE_NAME = ").append(this.escapeQuote(table));
        if (!nullable) {
            sb.append(" AND IS_NULLABLE = 'NO'");
        }
        return this.executeQuery(sb.toString());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT ' ' TABLE_CAT, ' ' TABLE_SCHEM, ' ' TABLE_NAME, ' ' COLUMN_NAME, 0 DATA_TYPE, 0 COLUMN_SIZE, 0 DECIMAL_DIGITS, 10 NUM_PREC_RADIX, ' ' COLUMN_USAGE,  ' ' REMARKS, 0 CHAR_OCTET_LENGTH, 'YES' IS_NULLABLE FROM DUAL WHERE 1=0");
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.conf.initialUrl();
    }

    @Override
    public String getUserName() {
        return this.conf.user();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        Statement st = this.connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT @@READ_ONLY");
        rs.next();
        return rs.getInt(1) == 1;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        return "SingleStore";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.getSingleStoreVersion().getVersion();
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return VersionFactory.getInstance().getVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return VersionFactory.getInstance().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return VersionFactory.getInstance().getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.connection.getTableNameCaseSensitivity();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return !this.connection.getTableNameCaseSensitivity();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.storesLowerCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesMixedCaseIdentifiers();
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public String getSQLKeywords() {
        return "ACCESSIBLE,ANALYZE,ASENSITIVE,BEFORE,BIGINT,BINARY,BLOB,CALL,CHANGE,CONDITION,DATABASE,DATABASES,DAY_HOUR,DAY_MICROSECOND,DAY_MINUTE,DAY_SECOND,DELAYED,DETERMINISTIC,DISTINCTROW,DIV,DUAL,EACH,ELSEIF,ENCLOSED,ESCAPED,EXIT,EXPLAIN,FLOAT4,FLOAT8,FORCE,FULLTEXT,GENERAL,HIGH_PRIORITY,HOUR_MICROSECOND,HOUR_MINUTE,HOUR_SECOND,IF,IGNORE,IGNORE_SERVER_IDS,INDEX,INFILE,INOUT,INT1,INT2,INT3,INT4,INT8,ITERATE,KEY,KEYS,KILL,LEAVE,LIMIT,LINEAR,LINES,LOAD,LOCALTIME,LOCALTIMESTAMP,LOCK,LONG,LONGBLOB,LONGTEXT,LOOP,LOW_PRIORITY,MASTER_HEARTBEAT_PERIOD,MASTER_SSL_VERIFY_SERVER_CERT,MAXVALUE,MEDIUMBLOB,MEDIUMINT,MEDIUMTEXT,MIDDLEINT,MINUTE_MICROSECOND,MINUTE_SECOND,MOD,MODIFIES,NO_WRITE_TO_BINLOG,OPTIMIZE,OPTIONALLY,OUT,OUTFILE,PURGE,RANGE,READ_WRITE,READS,REGEXP,RELEASE,RENAME,REPEAT,REPLACE,REQUIRE,RESIGNAL,RESTRICT,RETURN,RLIKE,SCHEMAS,SECOND_MICROSECOND,SENSITIVE,SEPARATOR,SHOW,SIGNAL,SLOW,SPATIAL,SPECIFIC,SQL_BIG_RESULT,SQL_CALC_FOUND_ROWS,SQL_SMALL_RESULT,SQLEXCEPTION,SSL,STARTING,STRAIGHT_JOIN,TERMINATED,TINYBLOB,TINYINT,TINYTEXT,TRIGGER,UNDO,UNLOCK,UNSIGNED,USE,UTC_DATE,UTC_TIME,UTC_TIMESTAMP,VARBINARY,VARCHARACTER,WHILE,XOR,YEAR_MONTH,ZEROFILL";
    }

    @Override
    public String getNumericFunctions() {
        return "DIV,ABS,ACOS,ASIN,ATAN,ATAN2,CEIL,CEILING,CONV,COS,COT,CRC32,DEGREES,EXP,FLOOR,GREATEST,LEAST,LN,LOG,LOG10,LOG2,MOD,OCT,PI,POW,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() {
        return "ASCII,BIN,BIT_LENGTH,CAST,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONVERT,ELT,EXPORT_SET,EXTRACTVALUE,FIELD,FIND_IN_SET,FORMAT,FROM_BASE64,HEX,INSTR,LCASE,LEFT,LENGTH,LIKE,LOAD_FILE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH AGAINST,MID,NOT LIKE,NOT REGEXP,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SOUNDS LIKE,SPACE,STRCMP,SUBSTR,SUBSTRING,SUBSTRING_INDEX,TO_BASE64,TRIM,UCASE,UNHEX,UPDATEXML,UPPER,WEIGHT_STRING";
    }

    @Override
    public String getSystemFunctions() {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,LAST_INSERT_ID,VERSION";
    }

    @Override
    public String getTimeDateFunctions() {
        return "ADDDATE,ADDTIME,CONVERT_TZ,CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DATEDIFF,DATE_ADD,DATE_FORMAT,DATE_SUB,DAY,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,EXTRACT,FROM_DAYS,FROM_UNIXTIME,GET_FORMAT,HOUR,LAST_DAY,LOCALTIME,LOCALTIMESTAMP,MAKEDATE,MAKETIME,MICROSECOND,MINUTE,MONTH,MONTHNAME,NOW,PERIOD_ADD,PERIOD_DIFF,QUARTER,SECOND,SEC_TO_TIME,STR_TO_DATE,SUBDATE,SUBTIME,SYSDATE,TIMEDIFF,TIMESTAMPADD,TIMESTAMPDIFF,TIME_FORMAT,TIME_TO_SEC,TO_DAYS,TO_SECONDS,UNIX_TIMESTAMP,UTC_DATE,UTC_TIME,UTC_TIMESTAMP,WEEK,WEEKDAY,WEEKOFYEAR,YEAR,YEARWEEK";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "#@";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                switch (toType) {
                    case -16: 
                    case -15: 
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        boolean isVersionGreaterThan8_5_0 = this.getSingleStoreVersion().versionGreaterOrEqual(8, 5, 0);
        return isVersionGreaterThan8_5_0 ? 256 : 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 64;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 64;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 256;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        boolean isVersionGreaterThan8_5_0 = this.getSingleStoreVersion().versionGreaterOrEqual(8, 5, 0);
        return isVersionGreaterThan8_5_0 ? 256 : 64;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        boolean isVersionGreaterThan8_5_0 = this.getSingleStoreVersion().versionGreaterOrEqual(8, 5, 0);
        return isVersionGreaterThan8_5_0 ? 256 : 64;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 256;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        switch (level) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT ROUTINE_SCHEMA PROCEDURE_CAT,NULL PROCEDURE_SCHEM, ROUTINE_NAME PROCEDURE_NAME, NULL RESERVED1, NULL RESERVED2, NULL RESERVED3, ROUTINE_COMMENT REMARKS, IF( DATA_TYPE = '', 1, 2) PROCEDURE_TYPE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.ROUTINES  WHERE " + this.catalogCond("ROUTINE_SCHEMA", catalog) + this.patternCond("ROUTINE_NAME", procedureNamePattern) + " AND ROUTINE_TYPE='PROCEDURE'";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String sql = this.parameterClause(true, "ROUTINE_SCHEMA", "NULL", String.valueOf(2), "0") + " FROM INFORMATION_SCHEMA.ROUTINES  WHERE " + this.catalogCond("ROUTINE_SCHEMA", catalog) + this.patternCond("SPECIFIC_NAME", procedureNamePattern) + this.patternCond("ROUTINE_NAME", columnNamePattern) + " AND ROUTINE_TYPE='PROCEDURE' AND DATA_TYPE != '' ORDER BY PROCEDURE_CAT, SPECIFIC_NAME UNION " + this.parameterClause(true, "SPECIFIC_SCHEMA", "PARAMETER_NAME", this.procedureReturnTypeClause(), "ORDINAL_POSITION") + " FROM INFORMATION_SCHEMA.PARAMETERS  WHERE " + this.catalogCond("SPECIFIC_SCHEMA", catalog) + this.patternCond("SPECIFIC_NAME", procedureNamePattern) + this.patternCond("PARAMETER_NAME", columnNamePattern) + " AND ROUTINE_TYPE='PROCEDURE' ORDER BY PROCEDURE_CAT, SPECIFIC_NAME, ORDINAL_POSITION";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String sql = this.parameterClause(false, "ROUTINE_SCHEMA", "NULL", String.valueOf(4), "0") + " FROM INFORMATION_SCHEMA.ROUTINES  WHERE " + this.catalogCond("ROUTINE_SCHEMA", catalog) + this.patternCond("SPECIFIC_NAME", functionNamePattern) + this.patternCond("ROUTINE_NAME", columnNamePattern) + " AND ROUTINE_TYPE='FUNCTION' ORDER BY FUNCTION_CAT, SPECIFIC_NAME UNION " + this.parameterClause(false, "SPECIFIC_SCHEMA", "PARAMETER_NAME", this.functionReturnTypeClause(), "ORDINAL_POSITION") + " FROM INFORMATION_SCHEMA.PARAMETERS  WHERE " + this.catalogCond("SPECIFIC_SCHEMA", catalog) + this.patternCond("SPECIFIC_NAME", functionNamePattern) + this.patternCond("PARAMETER_NAME", columnNamePattern) + " AND ROUTINE_TYPE='FUNCTION' ORDER BY FUNCTION_CAT, SPECIFIC_NAME, ORDINAL_POSITION";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.executeQuery("SELECT '' TABLE_SCHEM, '' TABLE_catalog  FROM DUAL WHERE 1=0");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.executeQuery("SELECT  ' ' table_schem, ' ' table_catalog FROM DUAL WHERE 1=0");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeQuery("SELECT SCHEMA_NAME TABLE_CAT FROM INFORMATION_SCHEMA.SCHEMATA ORDER BY 1");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.executeQuery("SELECT 'TABLE' TABLE_TYPE UNION SELECT 'TEMPORARY TABLE' TABLE_TYPE UNION SELECT 'GLOBAL TEMPORARY TABLE' TABLE_TYPE UNION SELECT 'SYSTEM VIEW' TABLE_TYPE UNION SELECT 'VIEW' TABLE_TYPE");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter must not be null");
        }
        String sql = "SELECT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, NULL AS GRANTOR, GRANTEE, PRIVILEGE_TYPE AS PRIVILEGE, IS_GRANTABLE FROM  INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE " + this.catalogCond("TABLE_SCHEMA", catalog) + " AND  TABLE_NAME = " + this.tableEscapeQuote(table) + this.patternCond("COLUMN_NAME", columnNamePattern) + " ORDER BY COLUMN_NAME, PRIVILEGE_TYPE";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String sql = "SELECT TABLE_SCHEMA TABLE_CAT,NULL  TABLE_SCHEM, TABLE_NAME, NULL GRANTOR,GRANTEE, PRIVILEGE_TYPE  PRIVILEGE, IS_GRANTABLE  FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES  WHERE " + this.catalogCond("TABLE_SCHEMA", catalog) + this.tablePatternCond("TABLE_NAME", tableNamePattern) + "ORDER BY TABLE_SCHEMA, TABLE_NAME,  PRIVILEGE_TYPE ";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT 0 SCOPE, ' ' COLUMN_NAME, 0 DATA_TYPE, ' ' TYPE_NAME, 0 COLUMN_SIZE, 0 BUFFER_LENGTH, 0 DECIMAL_DIGITS, 0 PSEUDO_COLUMN  FROM DUAL WHERE 1 = 0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException("SingleStore does not support foreign keys and referential integrity");
    }

    @Override
    public ResultSet getTypeInfo() {
        String[] columnNames = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        DataType[] dataTypes = new DataType[]{DataType.VARCHAR, DataType.INT, DataType.INT, DataType.VARCHAR, DataType.VARCHAR, DataType.VARCHAR, DataType.INT, DataType.BIT, DataType.SMALLINT, DataType.BIT, DataType.BIT, DataType.BIT, DataType.VARCHAR, DataType.SMALLINT, DataType.SMALLINT, DataType.INT, DataType.INT, DataType.INT};
        String[][] data = new String[][]{{"BIT", "-7", "1", "", "", "", "1", "1", "3", "0", "0", "0", "BIT", "0", "0", "0", "0", "10"}, {"BOOL", "-7", "1", "", "", "", "1", "1", "3", "0", "0", "0", "BOOL", "0", "0", "0", "0", "10"}, {"TINYINT", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "TINYINT", "0", "0", "0", "0", "10"}, {"TINYINT UNSIGNED", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "TINYINT UNSIGNED", "0", "0", "0", "0", "10"}, {"BIGINT", "-5", "19", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "BIGINT", "0", "0", "0", "0", "10"}, {"BIGINT UNSIGNED", "-5", "20", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "BIGINT UNSIGNED", "0", "0", "0", "0", "10"}, {"LONG VARBINARY", "-4", "16777215", "'", "'", "", "1", "1", "3", "0", "0", "0", "LONG VARBINARY", "0", "0", "0", "0", "10"}, {"MEDIUMBLOB", "-4", "16777215", "'", "'", "", "1", "1", "3", "0", "0", "0", "MEDIUMBLOB", "0", "0", "0", "0", "10"}, {"LONGBLOB", "-4", "2147483647", "'", "'", "", "1", "1", "3", "0", "0", "0", "LONGBLOB", "0", "0", "0", "0", "10"}, {"BLOB", "-4", "65535", "'", "'", "", "1", "1", "3", "0", "0", "0", "BLOB", "0", "0", "0", "0", "10"}, {"TINYBLOB", "-4", "255", "'", "'", "", "1", "1", "3", "0", "0", "0", "TINYBLOB", "0", "0", "0", "0", "10"}, {"VARBINARY", "-3", "255", "'", "'", "(M)", "1", "1", "3", "0", "0", "0", "VARBINARY", "0", "0", "0", "0", "10"}, {"BINARY", "-2", "255", "'", "'", "(M)", "1", "1", "3", "0", "0", "0", "BINARY", "0", "0", "0", "0", "10"}, {"LONG VARCHAR", "-1", "16777215", "'", "'", "", "1", "0", "3", "0", "0", "0", "LONG VARCHAR", "0", "0", "0", "0", "10"}, {"MEDIUMTEXT", "-1", "16777215", "'", "'", "", "1", "0", "3", "0", "0", "0", "MEDIUMTEXT", "0", "0", "0", "0", "10"}, {"LONGTEXT", "-1", "2147483647", "'", "'", "", "1", "0", "3", "0", "0", "0", "LONGTEXT", "0", "0", "0", "0", "10"}, {"TEXT", "-1", "65535", "'", "'", "", "1", "0", "3", "0", "0", "0", "TEXT", "0", "0", "0", "0", "10"}, {"TINYTEXT", "-1", "255", "'", "'", "", "1", "0", "3", "0", "0", "0", "TINYTEXT", "0", "0", "0", "0", "10"}, {"CHAR", "1", "255", "'", "'", "(M)", "1", "0", "3", "0", "0", "0", "CHAR", "0", "0", "0", "0", "10"}, {"NUMERIC", "2", "65", "", "", "[(M,D])] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "NUMERIC", "-308", "308", "0", "0", "10"}, {"DECIMAL", "3", "65", "", "", "[(M,D])] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "DECIMAL", "-308", "308", "0", "0", "10"}, {"INTEGER", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INTEGER", "0", "0", "0", "0", "10"}, {"INTEGER UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INTEGER UNSIGNED", "0", "0", "0", "0", "10"}, {"INT", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INT", "0", "0", "0", "0", "10"}, {"INT UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INT UNSIGNED", "0", "0", "0", "0", "10"}, {"MEDIUMINT", "4", "7", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "MEDIUMINT", "0", "0", "0", "0", "10"}, {"MEDIUMINT UNSIGNED", "4", "8", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "MEDIUMINT UNSIGNED", "0", "0", "0", "0", "10"}, {"SMALLINT", "5", "5", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "SMALLINT", "0", "0", "0", "0", "10"}, {"SMALLINT UNSIGNED", "5", "5", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "SMALLINT UNSIGNED", "0", "0", "0", "0", "10"}, {"FLOAT", "7", "10", "", "", "[(M|D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "FLOAT", "-38", "38", "0", "0", "10"}, {"DOUBLE", "8", "17", "", "", "[(M|D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "DOUBLE", "-308", "308", "0", "0", "10"}, {"DOUBLE PRECISION", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "DOUBLE PRECISION", "-308", "308", "0", "0", "10"}, {"REAL", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "REAL", "-308", "308", "0", "0", "10"}, {"VARCHAR", "12", "255", "'", "'", "(M)", "1", "0", "3", "0", "0", "0", "VARCHAR", "0", "0", "0", "0", "10"}, {"ENUM", "12", "65535", "'", "'", "", "1", "0", "3", "0", "0", "0", "ENUM", "0", "0", "0", "0", "10"}, {"SET", "12", "64", "'", "'", "", "1", "0", "3", "0", "0", "0", "SET", "0", "0", "0", "0", "10"}, {"DATE", "91", "10", "'", "'", "", "1", "0", "3", "0", "0", "0", "DATE", "0", "0", "0", "0", "10"}, {"TIME", "92", "18", "'", "'", "[(M)]", "1", "0", "3", "0", "0", "0", "TIME", "0", "0", "0", "0", "10"}, {"DATETIME", "93", "27", "'", "'", "[(M)]", "1", "0", "3", "0", "0", "0", "DATETIME", "0", "0", "0", "0", "10"}, {"TIMESTAMP", "93", "27", "'", "'", "[(M)]", "1", "0", "3", "0", "0", "0", "TIMESTAMP", "0", "0", "0", "0", "10"}};
        return CompleteResult.createResultSet(columnNames, dataTypes, data, this.connection.getContext(), 0, 1004);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter must not be null");
        }
        String sql = "SELECT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, NON_UNIQUE,  TABLE_SCHEMA INDEX_QUALIFIER, INDEX_NAME, 3 TYPE, SEQ_IN_INDEX ORDINAL_POSITION, COLUMN_NAME, COLLATION ASC_OR_DESC, CARDINALITY, NULL PAGES, NULL FILTER_CONDITION FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_NAME = " + this.tableEscapeQuote(table) + " AND " + this.catalogCond("TABLE_SCHEMA", catalog) + (unique ? " AND NON_UNIQUE = 0" : "") + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION";
        return this.executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "SELECT ' ' TYPE_CAT, NULL TYPE_SCHEM, ' ' TYPE_NAME, ' ' CLASS_NAME, 0 DATA_TYPE, ' ' REMARKS, 0 BASE_TYPE FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String sql = "SELECT  ' ' TYPE_CAT, NULL TYPE_SCHEM, ' ' TYPE_NAME, ' ' SUPERTYPE_CAT, ' ' SUPERTYPE_SCHEM, ' '  SUPERTYPE_NAME FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String sql = "SELECT  ' ' TABLE_CAT, ' ' TABLE_SCHEM, ' ' TABLE_NAME, ' ' SUPERTABLE_NAME FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String sql = "SELECT ' ' TYPE_CAT, ' ' TYPE_SCHEM, ' ' TYPE_NAME, ' ' ATTR_NAME, 0 DATA_TYPE, ' ' ATTR_TYPE_NAME, 0 ATTR_SIZE, 0 DECIMAL_DIGITS, 0 NUM_PREC_RADIX, 0 NULLABLE, ' ' REMARKS, ' ' ATTR_DEF,  0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB, 0 CHAR_OCTET_LENGTH, 0 ORDINAL_POSITION, ' ' IS_NULLABLE, ' ' SCOPE_CATALOG, ' ' SCOPE_SCHEMA, ' ' SCOPE_TABLE, 0 SOURCE_DATA_TYPE FROM DUAL  WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.getSingleStoreVersion().getMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.getSingleStoreVersion().getMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        String[] columnNames = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        DataType[] types = new DataType[]{DataType.VARCHAR, DataType.INT, DataType.VARCHAR, DataType.VARCHAR};
        String[][] data = new String[][]{{"ApplicationName", "16777215", "", "The name of the application currently utilizing the connection"}, {"ClientUser", "16777215", "", "The name of the user that the application using the connection is performing work for. This may not be the same as the user name that was used in establishing the connection."}, {"ClientHostname", "16777215", "", "The hostname of the computer the application using the connection is running on"}};
        return CompleteResult.createResultSet(columnNames, types, data, this.connection.getContext(), 0, 1004);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String sql = "SELECT ROUTINE_SCHEMA FUNCTION_CAT,NULL FUNCTION_SCHEM, ROUTINE_NAME FUNCTION_NAME, ROUTINE_COMMENT REMARKS,IF( DTD_IDENTIFIER LIKE 'TABLE', 2, 1) FUNCTION_TYPE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.ROUTINES  WHERE " + this.catalogCond("ROUTINE_SCHEMA", catalog) + this.patternCond("ROUTINE_NAME", functionNamePattern) + " AND ROUTINE_TYPE='FUNCTION' UNION SELECT AGGREGATE_SCHEMA FUNCTION_CAT,NULL FUNCTION_SCHEM, AGGREGATE_NAME FUNCTION_NAME, NULL REMARKS, " + 1 + " FUNCTION_TYPE, AGGREGATE_NAME SPECIFIC_NAME  FROM INFORMATION_SCHEMA.AGGREGATE_FUNCTIONS  WHERE " + this.catalogCond("AGGREGATE_SCHEMA", catalog) + this.patternCond("AGGREGATE_NAME", functionNamePattern);
        return this.executeQuery(sql);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0xFFFFFFFFL;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    public static class Identifier {
        public String schema;
        public String name;
    }
}

