/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class SingleStorePoolConnection
implements PooledConnection {
    private final Connection connection;
    private final List<ConnectionEventListener> connectionEventListeners;
    private final List<StatementEventListener> statementEventListeners;

    public SingleStorePoolConnection(Connection connection) {
        this.connection = connection;
        this.connection.setPoolConnection(this);
        this.statementEventListeners = new CopyOnWriteArrayList<StatementEventListener>();
        this.connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    public void fireStatementClosed(PreparedStatement statement) {
        StatementEvent event = new StatementEvent(this, statement);
        for (StatementEventListener listener : this.statementEventListeners) {
            listener.statementClosed(event);
        }
    }

    public void fireStatementErrorOccurred(PreparedStatement statement, SQLException returnEx) {
        StatementEvent event = new StatementEvent(this, statement, returnEx);
        for (StatementEventListener listener : this.statementEventListeners) {
            listener.statementErrorOccurred(event);
        }
    }

    public void fireConnectionClosed(ConnectionEvent event) {
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionClosed(event);
        }
    }

    public void fireConnectionErrorOccurred(SQLException returnEx) {
        ConnectionEvent event = new ConnectionEvent(this, returnEx);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionErrorOccurred(event);
        }
    }

    @Override
    public void close() throws SQLException {
        this.fireConnectionClosed(new ConnectionEvent(this));
        this.connection.setPoolConnection(null);
        this.connection.close();
    }
}

