/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.column;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.column.BlobColumn;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.type.LineString;
import com.singlestore.jdbc.type.Point;
import com.singlestore.jdbc.type.Polygon;
import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.util.Calendar;

public class GeometryColumn
extends BlobColumn {
    public GeometryColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    protected GeometryColumn(GeometryColumn prev) {
        super(prev);
    }

    @Override
    public GeometryColumn useAliasAsName() {
        return new GeometryColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        if (conf.geometryDefaultType() != null && "default".equals(conf.geometryDefaultType()) && this.extTypeName != null) {
            switch (this.extTypeName) {
                case "point": {
                    return Point.class.getName();
                }
                case "linestring": {
                    return LineString.class.getName();
                }
                case "polygon": {
                    return Polygon.class.getName();
                }
            }
        }
        return byte[].class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -3;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return this.dataType.name();
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.getDefaultBinary(conf, buf, length);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.dataType == DataType.CHAR) {
            String s = buf.readString(length.get());
            try {
                if (conf.geometryDefaultType() != null && "default".equals(conf.geometryDefaultType()) && this.extTypeName != null) {
                    switch (this.extTypeName) {
                        case "point": {
                            return new Point(s);
                        }
                        case "linestring": {
                            return new LineString(s);
                        }
                        case "polygon": {
                            return new Polygon(s);
                        }
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                throw new SQLDataException(String.format("Failed to decode '%s' as %s", s, this.extTypeName));
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as %s", new Object[]{this.dataType, this.extTypeName}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

