/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.EnumSet;

public class ReaderCodec
implements Codec<Reader> {
    public static final ReaderCodec INSTANCE = new ReaderCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.CHAR, new DataType[]{DataType.VARCHAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Reader.class);
    }

    @Override
    public String className() {
        return Reader.class.getName();
    }

    @Override
    public Reader decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length.get());
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Reader", new Object[]{column.getType()}));
                }
            }
            case CHAR: 
            case VARCHAR: {
                return new StringReader(buf.readString(length.get()));
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Reader", new Object[]{column.getType()}));
    }

    @Override
    public Reader decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return this.decodeText(buf, length, column, cal);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Reader;
    }

    @Override
    public int getApproximateTextProtocolLength(Object value) throws SQLException {
        return -1;
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar cal, Long maxLen) throws IOException {
        Reader reader = (Reader)val;
        encoder.writeByte(39);
        char[] buf = new char[4096];
        if (maxLen == null) {
            int len;
            while ((len = reader.read(buf)) >= 0) {
                byte[] data = new String(buf, 0, len).getBytes(StandardCharsets.UTF_8);
                encoder.writeBytesEscaped(data, data.length);
            }
        } else {
            int len;
            while ((len = reader.read(buf)) >= 0) {
                byte[] data = new String(buf, 0, Math.min(len, maxLen.intValue())).getBytes(StandardCharsets.UTF_8);
                maxLen = maxLen - (long)len;
                encoder.writeBytesEscaped(data, data.length);
            }
        }
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object val, Calendar cal, Long maxLength) throws IOException {
        int len;
        long maxLen;
        byte[] clobBytes = new byte[4096];
        int pos = 0;
        char[] buf = new char[4096];
        Reader reader = (Reader)val;
        long l = maxLen = maxLength != null ? maxLength : Long.MAX_VALUE;
        while (maxLen > 0L && (len = reader.read(buf)) > 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, maxLen)).getBytes(StandardCharsets.UTF_8);
            if (clobBytes.length - pos < data.length) {
                byte[] newBlobBytes = new byte[clobBytes.length + 65536];
                System.arraycopy(clobBytes, 0, newBlobBytes, 0, pos);
                clobBytes = newBlobBytes;
            }
            System.arraycopy(data, 0, clobBytes, pos, data.length);
            pos += data.length;
            maxLen -= (long)len;
        }
        encoder.writeLength(pos);
        encoder.writeBytes(clobBytes, 0, pos);
    }

    @Override
    public void encodeLongData(Writer encoder, Reader reader, Long maxLength) throws IOException {
        int len;
        long maxLen;
        char[] buf = new char[4096];
        long l = maxLen = maxLength != null ? maxLength : Long.MAX_VALUE;
        while (maxLen > 0L && (len = reader.read(buf)) >= 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, maxLen)).getBytes(StandardCharsets.UTF_8);
            encoder.writeBytes(data, 0, data.length);
            maxLen -= (long)len;
        }
    }

    @Override
    public byte[] encodeData(Reader reader, Long maxLength) throws IOException {
        int len;
        long maxLen;
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        char[] buf = new char[4096];
        long l = maxLen = maxLength != null ? maxLength : Long.MAX_VALUE;
        while (maxLen > 0L && (len = reader.read(buf)) >= 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, maxLen)).getBytes(StandardCharsets.UTF_8);
            bb.write(data, 0, data.length);
            maxLen -= (long)len;
        }
        return bb.toByteArray();
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARCHAR.get();
    }
}

