/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.export.HaMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HostAddress {
    public final String host;
    public int port;
    private Long threadsConnected;
    private Long threadConnectedTimeout;

    private HostAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static HostAddress from(String host, int port) {
        return new HostAddress(host, port);
    }

    public static List<HostAddress> parse(String spec, HaMode haMode) throws SQLException {
        if ("".equals(spec)) {
            return new ArrayList<HostAddress>(0);
        }
        String[] tokens = spec.trim().split(",");
        int size = tokens.length;
        ArrayList<HostAddress> arr = new ArrayList<HostAddress>(size);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.startsWith("address=")) {
                arr.add(HostAddress.parseParameterHostAddress(token));
                continue;
            }
            arr.add(HostAddress.parseSimpleHostAddress(token));
        }
        return arr;
    }

    private static HostAddress parseSimpleHostAddress(String str) throws SQLException {
        String host;
        int port = 3306;
        if (str.charAt(0) == '[') {
            int ind = str.indexOf(93);
            host = str.substring(1, ind);
            if (ind != str.length() - 1 && str.charAt(ind + 1) == ':') {
                port = HostAddress.getPort(str.substring(ind + 2));
            }
        } else if (str.contains(":")) {
            String[] hostPort = str.split(":");
            host = hostPort[0];
            port = HostAddress.getPort(hostPort[1]);
        } else {
            host = str;
        }
        return new HostAddress(host, port);
    }

    private static int getPort(String portString) throws SQLException {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException("Incorrect port value : " + portString);
        }
    }

    private static HostAddress parseParameterHostAddress(String str) throws SQLException {
        String host = null;
        int port = 3306;
        String[] array = str.replace(" ", "").split("(?=\\()|(?<=\\))");
        block8: for (int i = 1; i < array.length; ++i) {
            String[] token = array[i].replace("(", "").replace(")", "").trim().split("=");
            if (token.length != 2) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + array[i]);
            }
            String key = token[0].toLowerCase();
            String value = token[1].toLowerCase();
            switch (key) {
                case "host": {
                    host = value.replace("[", "").replace("]", "");
                    continue block8;
                }
                case "port": {
                    port = HostAddress.getPort(value);
                }
            }
        }
        return new HostAddress(host, port);
    }

    public String toString() {
        return String.format("address=(host=%s)(port=%s)", this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAddress that = (HostAddress)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public Long getThreadsConnected() {
        return this.threadsConnected;
    }

    public void setThreadsConnected(long threadsConnected) {
        this.threadsConnected = threadsConnected;
        this.threadConnectedTimeout = System.currentTimeMillis() + 180000L;
    }

    public void forceThreadsConnected(long threadsConnected, long threadConnectedTimeout) {
        this.threadsConnected = threadsConnected;
        this.threadConnectedTimeout = threadConnectedTimeout;
    }

    public Long getThreadConnectedTimeout() {
        return this.threadConnectedTimeout;
    }
}

