/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.ParameterMetaData;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.client.result.ResultSetMetaData;
import com.singlestore.jdbc.client.util.ClosableLock;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.export.Prepare;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.message.client.ExecutePacket;
import com.singlestore.jdbc.message.client.PreparePacket;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.util.ParameterList;
import com.singlestore.jdbc.util.timeout.QueryTimeoutHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class ServerPreparedStatement
extends BasePreparedStatement {
    private static final Pattern PREPARABLE_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|CALL)", 2);

    public ServerPreparedStatement(String sql, Connection con, ClosableLock lock, boolean canCachePrepStmts, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) throws SQLException {
        super(sql, con, lock, canCachePrepStmts, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        Prepare prepare = this.prepareResult = canCachePrepStmts ? con.getContext().getPrepareCacheCmd(sql, this) : null;
        if (this.prepareResult == null && !PREPARABLE_STATEMENT_PATTERN.matcher(sql).find()) {
            con.getClient().execute(new PreparePacket(sql), this, true);
        }
        this.parameters = new ParameterList();
    }

    protected void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        String cmd = this.escapeTimeout(this.sql);
        try (ClosableLock ignore = this.lock.closeableLock();
             QueryTimeoutHandler ignore2 = this.con.handleTimeout(this.queryTimeout);){
            this.executeStandard(cmd);
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
        }
    }

    private void executeStandard(String cmd) throws SQLException {
        if (this.prepareResult == null) {
            if (this.canCachePrepStmts) {
                this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
            }
            if (this.prepareResult == null) {
                this.con.getClient().execute(new PreparePacket(cmd), this, true);
            }
        }
        this.validParameters();
        ExecutePacket execute = new ExecutePacket(this.prepareResult, this.parameters, cmd, this, this.localInfileInputStream);
        this.results = this.con.getClient().execute(execute, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
    }

    private void executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        String cmd = this.escapeTimeout(this.sql);
        boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
        if (possibleLoadLocal) {
            String sqlUpper = this.sql.toUpperCase(Locale.ROOT);
            boolean bl = possibleLoadLocal = sqlUpper.contains(" LOCAL ") && sqlUpper.contains("LOAD") && sqlUpper.contains(" INFILE");
        }
        if (possibleLoadLocal) {
            this.executeBatchStandard(cmd);
        } else {
            this.executeBatchPipeline(cmd);
        }
    }

    private void executeBatchPipeline(String cmd) throws SQLException {
        if (this.prepareResult == null && this.canCachePrepStmts) {
            this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
        }
        int maxCmd = 250;
        ArrayList<Completion> res = new ArrayList<Completion>();
        try {
            int index = 0;
            if (this.prepareResult == null) {
                this.con.getClient().execute(new PreparePacket(cmd), this, false);
            }
            while (index < this.batchParameters.size()) {
                res.addAll(this.executeBunch(cmd, index, maxCmd));
                index += maxCmd;
            }
            this.results = res;
        }
        catch (SQLException bue) {
            this.results = null;
            throw this.exceptionFactory().createBatchUpdate(res, this.batchParameters.size(), bue);
        }
    }

    private List<Completion> executeBunch(String cmd, int index, int maxCmd) throws SQLException {
        int maxCmdToSend = Math.min(this.batchParameters.size() - index, maxCmd);
        ClientMessage[] packets = new ClientMessage[maxCmdToSend];
        for (int i = index; i < index + maxCmdToSend; ++i) {
            packets[i - index] = new ExecutePacket(this.prepareResult, (Parameters)this.batchParameters.get(i), cmd, this, this.localInfileInputStream);
        }
        return this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
    }

    private void executeBatchStandard(String cmd) throws SQLException {
        ArrayList<Completion> tmpResults = new ArrayList<Completion>();
        SQLException error = null;
        for (Parameters batchParameter : this.batchParameters) {
            if (this.prepareResult == null) {
                this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
                if (this.prepareResult == null) {
                    this.con.getClient().execute(new PreparePacket(cmd), this, false);
                }
            }
            try {
                ExecutePacket execute = new ExecutePacket(this.prepareResult, batchParameter, cmd, this, this.localInfileInputStream);
                tmpResults.addAll(this.con.getClient().execute(execute, this, false));
            }
            catch (SQLException e) {
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            throw this.exceptionFactory().createBatchUpdate(tmpResults, this.batchParameters.size(), error);
        }
        this.results = tmpResults;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.results.size() > 0) {
            this.currResult = (Completion)this.results.remove(0);
            return this.currResult instanceof Result;
        }
        return false;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.results.size() > 0) {
            this.currResult = (Completion)this.results.remove(0);
            if (this.currResult instanceof Result) {
                return (Result)this.currResult;
            }
        }
        if (Boolean.parseBoolean(this.con.getContext().getConf().nonMappedOptions().getProperty("permitNoResults", "false"))) {
            return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
        }
        throw new SQLException("PrepareStatement.executeQuery() command does NOT return a result-set as expected. Either use PrepareStatement.execute(), PrepareStatement.executeUpdate(), or correct command");
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    protected void handleParameterOutput() throws SQLException {
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = this.parameters.clone();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        } else {
            this.batchParameters.clear();
        }
    }

    protected void validParameters() throws SQLException {
        if (this.prepareResult != null) {
            for (int i = 0; i < this.prepareResult.getParameters().length; ++i) {
                if (this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        } else {
            if (this.batchParameters != null && !this.batchParameters.isEmpty() && this.parameters.size() < ((Parameters)this.batchParameters.get(0)).size()) {
                throw this.exceptionFactory().create("batch set of parameters differ from previous set. All parameters must be set", "07004");
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    /*
     * Exception decompiling
     */
    @Override
    public int[] executeBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    /*
     * Exception decompiling
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    @Override
    public String toString() {
        return "ServerPreparedStatement{" + super.toString() + '}';
    }
}

