/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.column;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.column.BlobColumn;
import com.singlestore.jdbc.client.util.MutableInt;
import java.sql.Blob;
import java.sql.SQLDataException;

public class BsonColumn
extends BlobColumn {
    public BsonColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    public BsonColumn(BsonColumn prev) {
        super(prev);
    }

    @Override
    public BsonColumn useAliasAsName() {
        return new BsonColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Blob.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -4;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return this.dataType.name();
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readBlob(length.get());
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.getDefaultText(conf, buf, length);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeBooleanText(buf, length);
    }
}

