/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.impl;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.SocketHelper;
import com.singlestore.jdbc.client.socket.Reader;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.socket.impl.SocketHandlerFunction;
import com.singlestore.jdbc.client.socket.impl.SocketUtility;
import com.singlestore.jdbc.export.SslMode;
import com.singlestore.jdbc.message.client.SslRequestPacket;
import com.singlestore.jdbc.message.server.AuthSwitchPacket;
import com.singlestore.jdbc.message.server.ErrorPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.plugin.AuthenticationPlugin;
import com.singlestore.jdbc.plugin.AuthenticationPluginFactory;
import com.singlestore.jdbc.plugin.Credential;
import com.singlestore.jdbc.plugin.CredentialPlugin;
import com.singlestore.jdbc.plugin.TlsSocketPlugin;
import com.singlestore.jdbc.plugin.authentication.AuthenticationPluginLoader;
import com.singlestore.jdbc.plugin.tls.TlsSocketPluginLoader;
import com.singlestore.jdbc.util.ConfigurableSocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class ConnectionHelper {
    private static final SocketHandlerFunction socketHandler;

    public static Socket createSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        return socketHandler.apply(conf, hostAddress);
    }

    public static Socket standardSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        String socketFactoryName = conf.socketFactory();
        if (socketFactoryName != null) {
            try {
                Class<?> socketFactoryClass = Class.forName(socketFactoryName, false, ConnectionHelper.class.getClassLoader());
                if (!SocketFactory.class.isAssignableFrom(socketFactoryClass)) {
                    throw new IOException("Wrong Socket factory implementation '" + conf.socketFactory() + "'");
                }
                Constructor<?> constructor = socketFactoryClass.getConstructor(new Class[0]);
                SocketFactory socketFactory = (SocketFactory)constructor.newInstance(new Object[0]);
                if (socketFactory instanceof ConfigurableSocketFactory) {
                    ((ConfigurableSocketFactory)socketFactory).setConfiguration(conf, hostAddress.host);
                }
                return socketFactory.createSocket();
            }
            catch (Exception exp) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + conf.socketFactory() + "\"", exp);
            }
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket();
    }

    public static Socket connectSocket(Configuration conf, HostAddress hostAddress) throws SQLException {
        try {
            if (conf.pipe() == null && conf.localSocket() == null && hostAddress == null) {
                throw new SQLException("hostname must be set to connect socket if not using local socket or pipe");
            }
            Socket socket = ConnectionHelper.createSocket(conf, hostAddress);
            SocketHelper.setSocketOption(conf, socket);
            if (!socket.isConnected()) {
                InetSocketAddress sockAddr = conf.pipe() == null && conf.localSocket() == null ? new InetSocketAddress(hostAddress.host, hostAddress.port) : null;
                socket.connect(sockAddr, conf.connectTimeout());
            }
            return socket;
        }
        catch (SocketTimeoutException ste) {
            throw new SQLTimeoutException(String.format("Socket timeout when connecting to %s. %s", hostAddress, ste.getMessage()), "08000", ste);
        }
        catch (IOException ioe) {
            throw new SQLNonTransientConnectionException(String.format("Socket fail to connect to host:%s. %s", hostAddress == null ? conf.localSocket() : hostAddress, ioe.getMessage()), "08000", ioe);
        }
    }

    public static long initializeClientCapabilities(Configuration configuration, long serverCapabilities, HostAddress hostAddress) {
        boolean extendedTypeInfo;
        long capabilities = 12493568L;
        if (configuration.useServerPrepStmts() && Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("enableSkipMeta", "true"))) {
            capabilities |= 0x1000000000L;
        }
        if (!configuration.useAffectedRows()) {
            capabilities |= 2L;
        }
        if (configuration.allowMultiQueries()) {
            capabilities |= 0x10000L;
        }
        if (configuration.allowLocalInfile()) {
            capabilities |= 0x80L;
        }
        if (extendedTypeInfo = Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("extendedTypeInfo", "true"))) {
            capabilities |= 0x800000000L;
        }
        boolean useEof = Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("useEof", "true"));
        if ((serverCapabilities & 0x1000000L) != 0L && useEof) {
            capabilities |= 0x1000000L;
        }
        if (configuration.useCompression() && (serverCapabilities & 0x20L) != 0L) {
            capabilities |= 0x20L;
        }
        if (configuration.database() != null && !configuration.createDatabaseIfNotExist()) {
            capabilities |= 8L;
        }
        if (configuration.sslMode() != SslMode.DISABLE) {
            capabilities |= 0x800L;
        }
        return capabilities;
    }

    public static void authenticationHandler(Credential credential, Writer writer, Reader reader, Context context) throws SQLException, IOException {
        writer.permitTrace(true);
        Configuration conf = context.getConf();
        ReadableByteBuf buf = reader.readReusablePacket();
        block5: while (true) {
            switch (buf.getByte() & 0xFF) {
                case 254: {
                    AuthSwitchPacket authSwitchPacket = AuthSwitchPacket.decode(buf);
                    AuthenticationPluginFactory authPluginFactory = AuthenticationPluginLoader.get(authSwitchPacket.getPlugin(), conf);
                    if (authPluginFactory.requireSsl() && !context.hasClientCapability(2048L)) {
                        throw context.getExceptionFactory().create("Cannot use authentication plugin " + authPluginFactory.type() + " if SSL is not enabled.", "08000");
                    }
                    AuthenticationPlugin authenticationPlugin = authPluginFactory.initialize(credential.getPassword(), authSwitchPacket.getSeed(), conf);
                    buf = authenticationPlugin.process(writer, reader, context);
                    continue block5;
                }
                case 255: {
                    ErrorPacket errorPacket = new ErrorPacket(buf, context);
                    throw context.getExceptionFactory().create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
                }
                case 0: {
                    new OkPacket(buf, context);
                    break block5;
                }
                default: {
                    throw context.getExceptionFactory().create("unexpected data during authentication (header=" + buf.getUnsignedByte(), "08000");
                }
            }
            break;
        }
        writer.permitTrace(true);
    }

    public static Credential loadCredential(CredentialPlugin credentialPlugin, Configuration configuration, HostAddress hostAddress) throws SQLException {
        if (credentialPlugin != null) {
            return credentialPlugin.initialize(configuration, configuration.user(), hostAddress).get();
        }
        return new Credential(configuration.user(), configuration.password());
    }

    public static SSLSocket sslWrapper(HostAddress hostAddress, Socket socket, long clientCapabilities, byte exchangeCharset, Context context, Writer writer) throws SQLException, IOException {
        Configuration conf = context.getConf();
        if (conf.sslMode() != SslMode.DISABLE) {
            SSLSocketFactory sslSocketFactory;
            if (!context.hasServerCapability(2048L)) {
                throw context.getExceptionFactory().create("Trying to connect with ssl, but ssl not enabled in the server", "08000");
            }
            SslRequestPacket.create(clientCapabilities |= 0x800L, exchangeCharset).encode(writer, context);
            TlsSocketPlugin socketPlugin = TlsSocketPluginLoader.get(conf.tlsSocketType());
            TrustManager[] trustManagers = socketPlugin.getTrustManager(conf, context.getExceptionFactory());
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(socketPlugin.getKeyManager(conf, context.getExceptionFactory()), trustManagers, null);
                sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyManagementException keyManagementEx) {
                throw context.getExceptionFactory().create("Could not initialize SSL context", "08000", keyManagementEx);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmEx) {
                throw context.getExceptionFactory().create("SSLContext TLS Algorithm not unknown", "08000", noSuchAlgorithmEx);
            }
            SSLSocket sslSocket = socketPlugin.createSocket(socket, sslSocketFactory);
            ConnectionHelper.enabledSslProtocolSuites(sslSocket, conf);
            ConnectionHelper.enabledSslCipherSuites(sslSocket, conf);
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
            if (conf.sslMode() == SslMode.VERIFY_FULL && hostAddress != null) {
                SSLSession session = sslSocket.getSession();
                try {
                    socketPlugin.verify(hostAddress.host, session, context.getThreadId());
                }
                catch (SSLException ex) {
                    throw context.getExceptionFactory().create("SSL hostname verification failed : " + ex.getMessage() + "\nThis verification can be disabled using the sslMode to VERIFY_CA but won't prevent man-in-the-middle attacks anymore", "08006");
                }
            }
            return sslSocket;
        }
        return null;
    }

    static void enabledSslProtocolSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslProtocolSuites() != null) {
            String[] protocols;
            List<String> possibleProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
            for (String protocol : protocols = conf.enabledSslProtocolSuites().split("[,;\\s]+")) {
                if (possibleProtocols.contains(protocol)) continue;
                throw new SQLException("Unsupported SSL protocol '" + protocol + "'. Supported protocols : " + possibleProtocols.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    static void enabledSslCipherSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslCipherSuites() != null) {
            String[] ciphers;
            List<String> possibleCiphers = Arrays.asList(sslSocket.getSupportedCipherSuites());
            for (String cipher : ciphers = conf.enabledSslCipherSuites().split("[,;\\s]+")) {
                if (possibleCiphers.contains(cipher)) continue;
                throw new SQLException("Unsupported SSL cipher '" + cipher + "'. Supported ciphers : " + possibleCiphers.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledCipherSuites(ciphers);
        }
    }

    static {
        SocketHandlerFunction init;
        try {
            init = SocketUtility.getSocketHandler();
        }
        catch (Throwable t) {
            init = ConnectionHelper::standardSocket;
        }
        socketHandler = init;
    }
}

