/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.impl;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.ServerPreparedStatement;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.Client;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.BaseContext;
import com.singlestore.jdbc.client.context.RedoContext;
import com.singlestore.jdbc.client.impl.ConnectionHelper;
import com.singlestore.jdbc.client.impl.PrepareCache;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.client.result.StreamingResult;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.socket.impl.CompressInputStream;
import com.singlestore.jdbc.client.socket.impl.CompressOutputStream;
import com.singlestore.jdbc.client.socket.impl.PacketReader;
import com.singlestore.jdbc.client.socket.impl.PacketWriter;
import com.singlestore.jdbc.client.socket.impl.ReadAheadBufferedStream;
import com.singlestore.jdbc.client.util.ClosableLock;
import com.singlestore.jdbc.client.util.MutableByte;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.export.MaxAllowedPacketException;
import com.singlestore.jdbc.export.Prepare;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.message.client.ClosePreparePacket;
import com.singlestore.jdbc.message.client.HandshakeResponse;
import com.singlestore.jdbc.message.client.QueryPacket;
import com.singlestore.jdbc.message.client.QuitPacket;
import com.singlestore.jdbc.message.server.ErrorPacket;
import com.singlestore.jdbc.message.server.InitialHandshakePacket;
import com.singlestore.jdbc.message.server.PrepareResultPacket;
import com.singlestore.jdbc.plugin.Credential;
import com.singlestore.jdbc.plugin.CredentialPlugin;
import com.singlestore.jdbc.plugin.credential.browser.BrowserCredentialPlugin;
import com.singlestore.jdbc.util.Security;
import com.singlestore.jdbc.util.Version;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLSocket;

public class StandardClient
implements Client,
AutoCloseable {
    protected final ExceptionFactory exceptionFactory;
    private Socket socket;
    private final MutableByte sequence = new MutableByte();
    private final MutableByte compressionSequence = new MutableByte();
    private final ClosableLock lock;
    private final Configuration conf;
    private final HostAddress hostAddress;
    private final boolean disablePipeline;
    protected Writer writer;
    protected Context context;
    private boolean closed = false;
    private PacketReader reader;
    private Statement streamStmt = null;
    private ClientMessage streamMsg = null;
    private int socketTimeout;
    private BigInteger aggregatorId;
    private BigInteger initialSqlSelectLimit;
    private Version singleStoreVersion;

    public StandardClient(Configuration conf, HostAddress hostAddress, ClosableLock lock, boolean skipPostCommands) throws SQLException {
        this.conf = conf;
        this.lock = lock;
        this.hostAddress = hostAddress;
        this.exceptionFactory = new ExceptionFactory(conf, hostAddress);
        this.disablePipeline = conf.disablePipeline();
        this.socketTimeout = conf.socketTimeout();
        String host = hostAddress != null ? hostAddress.host : null;
        try {
            this.connect(host, skipPostCommands);
        }
        catch (SQLInvalidAuthorizationSpecException sqlException) {
            if (conf.credentialPlugin() != null && conf.credentialPlugin().type().contains("BROWSER_SSO") && sqlException.getErrorCode() == 1045 || sqlException.getErrorCode() == 2628) {
                BrowserCredentialPlugin credPlugin = (BrowserCredentialPlugin)conf.credentialPlugin();
                Loggers.getLogger(StandardClient.class).debug("Failed to connect with the JWT, retrying browser auth");
                credPlugin.clearKeyring();
                credPlugin.clearLocalCache();
                this.closed = false;
                this.connect(host, skipPostCommands);
            }
            throw sqlException;
        }
    }

    private void connect(String host, boolean skipPostCommands) throws SQLException {
        this.socket = ConnectionHelper.connectSocket(this.conf, this.hostAddress);
        try {
            OutputStream out = this.socket.getOutputStream();
            FilterInputStream in = this.conf.useReadAheadInput() ? new ReadAheadBufferedStream(this.socket.getInputStream()) : new BufferedInputStream(this.socket.getInputStream(), 16384);
            this.assignStream(out, in, this.conf, null);
            if (this.conf.connectTimeout() > 0) {
                this.setSocketTimeout(this.conf.connectTimeout());
            } else if (this.conf.socketTimeout() > 0) {
                this.setSocketTimeout(this.conf.socketTimeout());
            }
            ReadableByteBuf buf = this.reader.readReusablePacket(Loggers.getLogger(StandardClient.class).isTraceEnabled());
            if (buf.getByte() == -1) {
                ErrorPacket errorPacket = new ErrorPacket(buf, null);
                throw this.exceptionFactory.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            InitialHandshakePacket handshake = InitialHandshakePacket.decode(buf);
            this.exceptionFactory.setThreadId(handshake.getThreadId());
            long clientCapabilities = ConnectionHelper.initializeClientCapabilities(this.conf, handshake.getCapabilities(), this.hostAddress);
            this.context = this.conf.transactionReplay() ? new RedoContext(this.hostAddress, handshake, clientCapabilities, this.conf, this.exceptionFactory, new PrepareCache(this.conf.prepStmtCacheSize(), this)) : new BaseContext(this.hostAddress, handshake, clientCapabilities, this.conf, this.exceptionFactory, new PrepareCache(this.conf.prepStmtCacheSize(), this));
            this.reader.setServerThreadId(handshake.getThreadId(), this.hostAddress);
            this.writer.setServerThreadId(handshake.getThreadId(), this.hostAddress);
            SSLSocket sslSocket = ConnectionHelper.sslWrapper(this.hostAddress, this.socket, clientCapabilities, (byte)handshake.getDefaultCollation(), this.context, this.writer);
            if (sslSocket != null) {
                out = new BufferedOutputStream(sslSocket.getOutputStream(), 16384);
                in = this.conf.useReadAheadInput() ? new ReadAheadBufferedStream(sslSocket.getInputStream()) : new BufferedInputStream(sslSocket.getInputStream(), 16384);
                this.assignStream(out, in, this.conf, handshake.getThreadId());
            }
            String authenticationPluginType = handshake.getAuthenticationPluginType();
            CredentialPlugin credentialPlugin = this.conf.credentialPlugin();
            if (credentialPlugin != null && credentialPlugin.defaultAuthenticationPluginType() != null) {
                authenticationPluginType = credentialPlugin.defaultAuthenticationPluginType();
            }
            if ("mysql_clear_password".equals(authenticationPluginType) && !this.context.hasClientCapability(2048L)) {
                throw this.context.getExceptionFactory().create("Cannot use authentication plugin mysql_clear_password if SSL is not enabled.", "08000");
            }
            Credential credential = ConnectionHelper.loadCredential(credentialPlugin, this.conf, this.hostAddress);
            new HandshakeResponse(credential, authenticationPluginType, this.context.getSeed(), this.conf, host, clientCapabilities, (byte)handshake.getDefaultCollation()).encode(this.writer, this.context);
            this.writer.flush();
            ConnectionHelper.authenticationHandler(credential, this.writer, this.reader, this.context);
            if ((clientCapabilities & 0x20L) != 0L) {
                this.assignStream(new CompressOutputStream(out, this.compressionSequence), new CompressInputStream(in, this.compressionSequence), this.conf, handshake.getThreadId());
            }
            if (!skipPostCommands) {
                this.postConnectionQueries();
            }
            this.setSocketTimeout(this.conf.socketTimeout());
        }
        catch (SQLException sqlException) {
            this.destroySocket();
            throw sqlException;
        }
        catch (SocketTimeoutException ste) {
            this.destroySocket();
            throw new SQLTimeoutException(String.format("Socket timeout when connecting to %s. %s", this.hostAddress, ste.getMessage()), "08000", ste);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.create(String.format("Could not connect to %s : %s", this.hostAddress, ioException.getMessage()), "08000", ioException);
        }
    }

    private void assignStream(OutputStream out, InputStream in, Configuration conf, Long threadId) {
        this.writer = new PacketWriter(out, conf.maxQuerySizeToLog(), conf.maxAllowedPacket(), this.sequence, this.compressionSequence);
        this.writer.setServerThreadId(threadId, this.hostAddress);
        this.reader = new PacketReader(in, conf, this.sequence);
        this.reader.setServerThreadId(threadId, this.hostAddress);
    }

    protected void destroySocket() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void postConnectionQueries() throws SQLException {
        ArrayList<String> commands = new ArrayList<String>();
        int resInd = 0;
        if (this.conf.sessionVariables() != null) {
            commands.add("set " + Security.parseSessionVariables(this.conf.sessionVariables()));
            ++resInd;
        }
        if (this.conf.autocommit() != null) {
            commands.add("set autocommit=" + (this.conf.autocommit() != false ? "true" : "false"));
            ++resInd;
        }
        if (this.conf.database() != null && this.conf.createDatabaseIfNotExist()) {
            String escapedDb = this.conf.database().replace("`", "``");
            commands.add(String.format("CREATE DATABASE IF NOT EXISTS `%s`", escapedDb));
            commands.add(String.format("USE `%s`", escapedDb));
            resInd += 2;
        }
        if (this.conf.initSql() != null) {
            commands.add(this.conf.initSql());
            ++resInd;
        }
        if (this.conf.nonMappedOptions().containsKey("initSql")) {
            String[] initialCommands = this.conf.nonMappedOptions().get("initSql").toString().split(";");
            commands.addAll(Arrays.asList(initialCommands));
            resInd += initialCommands.length;
        }
        commands.add("SELECT @@max_allowed_packet, @@aggregator_id, @@sql_select_limit, @@memsql_version");
        try {
            ClientMessage[] msgs = new ClientMessage[commands.size()];
            for (int i = 0; i < commands.size(); ++i) {
                msgs[i] = new QueryPacket((String)commands.get(i));
            }
            List<Completion> res = this.executePipeline(msgs, null, 0, 0L, 1007, 1003, false, true);
            Result result = (Result)res.get(resInd);
            if (result.next()) {
                this.writer.setMaxAllowedPacket(result.getInt(1));
                this.aggregatorId = result.getBigInteger(2);
                this.initialSqlSelectLimit = result.getBigInteger(3);
                this.singleStoreVersion = new Version(result.getString(4));
            }
            this.initializeExtendedTypesMetadata();
        }
        catch (SQLException sqlException) {
            throw this.exceptionFactory.create("Initialization command fail", "08000", sqlException);
        }
    }

    private void initializeExtendedTypesMetadata() throws SQLException {
        if (this.singleStoreVersion != null && this.singleStoreVersion.versionGreaterOrEqual(8, 7, 1)) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("SET @@SESSION.enable_extended_types_metadata=" + (this.conf.enableExtendedDataTypes() ? "on" : "off"));
            if (this.conf.vectorTypeOutputFormat() != null) {
                commands.add(String.format("SET @@SESSION.vector_type_project_format=%s", this.conf.vectorTypeOutputFormat()));
            }
            ClientMessage[] msgs = new ClientMessage[commands.size()];
            for (int i = 0; i < commands.size(); ++i) {
                msgs[i] = new QueryPacket((String)commands.get(i));
            }
            this.executePipeline(msgs, null, 0, 0L, 1007, 1003, false, true);
        } else if (this.conf.enableExtendedDataTypes() || this.conf.vectorTypeOutputFormat() != null) {
            Loggers.getLogger(StandardClient.class).warn("Configuration parameters: 'enableExtendedDataTypes' and 'vectorTypeOutputFormat' are not supported for SingleStore versions earlier than 8.7.1.");
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
    }

    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            Logger logger = Loggers.getLogger(StandardClient.class);
            if (logger.isDebugEnabled() && message.description() != null) {
                logger.debug("execute query: {}", message.description());
            }
            return message.encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            if (ioException instanceof MaxAllowedPacketException) {
                if (((MaxAllowedPacketException)ioException).isMustReconnect()) {
                    this.destroySocket();
                    throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", ioException);
                }
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", ioException);
            }
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, boolean canRedo) throws SQLException {
        return this.execute(message, null, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, boolean canRedo) throws SQLException {
        return this.execute(message, stmt, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        ArrayList<Completion> results = new ArrayList<Completion>();
        int perMsgCounter = 0;
        int readCounter = 0;
        int[] responseMsg = new int[messages.length];
        try {
            if (this.disablePipeline) {
                for (readCounter = 0; readCounter < messages.length; ++readCounter) {
                    results.addAll(this.execute(messages[readCounter], stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo));
                }
            } else {
                for (int i = 0; i < messages.length; ++i) {
                    responseMsg[i] = this.sendQuery(messages[i]);
                }
                while (readCounter < messages.length) {
                    ++readCounter;
                    for (perMsgCounter = 0; perMsgCounter < responseMsg[readCounter - 1]; ++perMsgCounter) {
                        results.addAll(this.readResponse(stmt, messages[readCounter - 1], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                    }
                }
            }
            return results;
        }
        catch (SQLException sqlException) {
            if (!this.closed) {
                results.add(null);
                ++perMsgCounter;
                while (readCounter > 0 && perMsgCounter < responseMsg[readCounter - 1]) {
                    try {
                        results.addAll(this.readResponse(stmt, messages[readCounter - 1], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ++perMsgCounter;
                }
                for (int i = readCounter; i < messages.length; ++i) {
                    for (int j = 0; j < responseMsg[i]; ++j) {
                        try {
                            results.addAll(this.readResponse(stmt, messages[i], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                            continue;
                        }
                        catch (SQLException e) {
                            results.add(null);
                        }
                    }
                }
                for (Completion result : results) {
                    if (!(result instanceof PrepareResultPacket) || !(stmt instanceof ServerPreparedStatement)) continue;
                    try {
                        ((PrepareResultPacket)result).decrementUse(this, (ServerPreparedStatement)stmt);
                    }
                    catch (SQLException sQLException) {}
                }
            }
            int batchUpdateLength = 0;
            for (ClientMessage message : messages) {
                batchUpdateLength += message.batchUpdateLength();
            }
            throw this.exceptionFactory.createBatchUpdate(results, batchUpdateLength, responseMsg, sqlException);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> completions = this.executeInternal(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        return completions;
    }

    private List<Completion> executeInternal(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        int nbResp = this.sendQuery(message);
        if (nbResp == 1) {
            return this.readResponse(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        try {
            while (nbResp-- > 0) {
                this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
            }
            return completions;
        }
        catch (SQLException e) {
            while (nbResp-- > 0) {
                try {
                    this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
                }
                catch (SQLException sQLException) {}
            }
            throw e;
        }
    }

    public List<Completion> readResponse(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        return completions;
    }

    public void readResponse(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(null, message, completions, 0, 0L, 1007, 1003, false);
    }

    @Override
    public void closePrepare(Prepare prepare) throws SQLException {
        this.checkNotClosed();
        try {
            new ClosePreparePacket(prepare.getStatementId()).encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.create("Socket error during post connection queries: " + ioException.getMessage(), "08000", ioException);
        }
    }

    @Override
    public void readStreamingResults(List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        if (this.streamStmt != null) {
            this.readResults(this.streamStmt, this.streamMsg, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
    }

    private void readResults(Statement stmt, ClientMessage message, List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        while ((this.context.getServerStatus() & 8) > 0) {
            completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        }
    }

    public Completion readPacket(ClientMessage message) throws SQLException {
        return this.readPacket(null, message, 0, 0L, 1007, 1003, false);
    }

    public Completion readPacket(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        try {
            boolean traceEnable = Loggers.getLogger(StandardClient.class).isTraceEnabled();
            Completion completion = message.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, this.reader, this.writer, this.context, this.exceptionFactory, this.lock, traceEnable, message);
            if (completion instanceof StreamingResult && !((StreamingResult)completion).loaded()) {
                this.streamStmt = stmt;
                this.streamMsg = message;
            }
            return completion;
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create(ioException instanceof SocketTimeoutException ? "Socket timeout error" : "Socket error", "08000", ioException);
        }
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            try {
                long maxCurrentMillis = System.currentTimeMillis() + 10L;
                this.socket.shutdownOutput();
                this.socket.setSoTimeout(3);
                InputStream is = this.socket.getInputStream();
                while (is.read() != -1 && System.currentTimeMillis() < maxCurrentMillis) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer.close();
            this.reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw this.exceptionFactory.create("Cannot abort the connection: null executor passed");
        }
        boolean lockStatus = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            Loggers.getLogger(StandardClient.class).debug("aborting connection {}", this.context.getThreadId());
            if (!lockStatus) {
                try (StandardClient cli = new StandardClient(this.conf, this.hostAddress, new ClosableLock(), true);){
                    cli.execute(new QueryPacket("KILL " + this.context.getThreadId()), false);
                }
                catch (SQLException sQLException) {}
            } else {
                try {
                    QuitPacket.INSTANCE.encode(this.writer, this.context);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.streamStmt != null) {
                this.streamStmt.abort();
            }
            this.closeSocket();
        }
        if (lockStatus) {
            this.lock.unlock();
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int milliseconds) throws SQLException {
        try {
            this.socketTimeout = milliseconds;
            this.socket.setSoTimeout(milliseconds);
        }
        catch (SocketException se) {
            throw this.exceptionFactory.create("Cannot set the network timeout", "42000", se);
        }
    }

    @Override
    public void close() throws SQLException {
        boolean locked = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            try {
                QuitPacket.INSTANCE.encode(this.writer, this.context);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeSocket();
        }
        if (locked) {
            this.lock.unlock();
        }
    }

    @Override
    public String getSocketIp() {
        return this.socket.getInetAddress() == null ? null : this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public BigInteger getAggregatorId() {
        return this.aggregatorId;
    }

    @Override
    public BigInteger getInitialSqlSelectLimit() {
        return this.initialSqlSelectLimit;
    }

    @Override
    public Version getSingleStoreVersion() {
        return this.singleStoreVersion;
    }

    @Override
    public void reset() {
        this.context.resetStateFlag();
        this.context.resetPrepareCache();
    }
}

