/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import com.singlestore.jdbc.plugin.codec.ByteArrayCodec;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;

public class FloatObjectArrayCodec
implements Codec<Float[]> {
    public static final FloatObjectArrayCodec INSTANCE = new FloatObjectArrayCodec();
    private static Class<?> floatArrayClass = Array.newInstance(Float.class, 0).getClass();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.VARCHAR);
    static final int BYTES_IN_FLOAT = 4;

    @Override
    public String className() {
        return float[].class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && !type.isPrimitive() && type == floatArrayClass && type.isArray();
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Float[];
    }

    @Override
    public int getApproximateTextProtocolLength(Object value) throws SQLException {
        return this.canEncode(value) ? Arrays.toString((Object[])((Float[])value)).getBytes().length : -1;
    }

    @Override
    public Float[] decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return FloatObjectArrayCodec.toFloatArray(this.getBytes(buf, length, column));
    }

    @Override
    public Float[] decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return FloatObjectArrayCodec.toFloatArray(this.getBytes(buf, length, column));
    }

    public static byte[] toByteArray(Float[] floatArray) {
        byte[] buf = new byte[floatArray.length * 4];
        int pos = 0;
        for (Float f : floatArray) {
            int value = Float.floatToIntBits(f.floatValue());
            buf[pos] = (byte)value;
            buf[pos + 1] = (byte)(value >> 8);
            buf[pos + 2] = (byte)(value >> 16);
            buf[pos + 3] = (byte)(value >> 24);
            pos += 4;
        }
        return buf;
    }

    public static Float[] toFloatArray(byte[] byteArray) {
        int len = (int)Math.ceil((double)byteArray.length / 4.0);
        Float[] res = new Float[len];
        int pos = 0;
        while (pos < len) {
            int value;
            if (pos + 1 <= len) {
                value = (byteArray[pos * 4] & 0xFF) + ((byteArray[pos * 4 + 1] & 0xFF) << 8) + ((byteArray[pos * 4 + 2] & 0xFF) << 16) + ((byteArray[pos * 4 + 3] & 0xFF) << 24);
            } else {
                value = byteArray[pos * 4] & 0xFF;
                if (pos + 1 < byteArray.length) {
                    value += (byteArray[pos * 4 + 1] & 0xFF) << 8;
                }
                if (pos + 2 < byteArray.length) {
                    value += (byteArray[pos * 4 + 2] & 0xFF) << 16;
                }
            }
            res[pos++] = Float.valueOf(Float.intBitsToFloat(value));
        }
        return res;
    }

    private byte[] getBytes(ReadableByteBuf buf, MutableInt length, ColumnDecoder column) throws SQLDataException {
        switch (column.getType()) {
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case VARCHAR: 
            case GEOMETRY: {
                byte[] arr = new byte[length.get()];
                buf.readBytes(arr);
                return arr;
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as float[]", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        byte[] encoded = FloatObjectArrayCodec.toByteArray((Float[])value);
        encoder.writeBytes(ByteArrayCodec.BINARY_PREFIX);
        encoder.writeBytesEscaped(encoded, encoded.length);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        byte[] arr = FloatObjectArrayCodec.toByteArray((Float[])value);
        encoder.writeLength(arr.length);
        encoder.writeBytes(arr);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

