/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.column;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.type.Vector;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class VectorColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    private static final String VECTOR_TYPE_NAME = "VECTOR";

    public VectorColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected VectorColumn(VectorColumn prev) {
        super(prev, true);
    }

    @Override
    public VectorColumn useAliasAsName() {
        return new VectorColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        if (this.extTypeFormat != null) {
            return Vector.class.getName();
        }
        return this.isBinary() ? byte[].class.getName() : String.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        if (this.extTypeFormat != null) {
            return 1111;
        }
        return this.isBinary() ? -3 : 12;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (this.extTypeFormat != null) {
            if (conf.vectorExtendedMetadata()) {
                return String.format("VECTOR(%s)", this.extTypeFormat);
            }
            return VECTOR_TYPE_NAME;
        }
        return this.isBinary() ? "VARBINARY" : "VARCHAR";
    }

    @Override
    public int getPrecision() {
        if (this.dataType != DataType.NULL) {
            return this.getDisplaySize();
        }
        return ColumnDecoder.super.getPrecision();
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        Object object;
        byte[] arr = new byte[length.get()];
        buf.readBytes(arr);
        if (this.extTypeFormat != null) {
            int dimensions = Integer.parseInt(this.extTypeFormat.split(",")[0]);
            return Vector.fromData(arr, dimensions, this.dataType, this.isBinary());
        }
        if (this.isBinary()) {
            object = arr;
        } else {
            String string;
            object = string;
            string = new String(arr);
        }
        return object;
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.getDefaultText(conf, buf, length);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeBooleanText(buf, length);
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeByteText(buf, length);
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return this.decodeStringText(buf, length, cal);
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeShortText(buf, length);
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeIntText(buf, length);
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeLongText(buf, length);
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeFloatText(buf, length);
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeDoubleText(buf, length);
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return this.decodeDateText(buf, length, cal);
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        return this.decodeTimeText(buf, length, calParam);
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return this.decodeTimestampText(buf, length, cal);
    }
}

