/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.codec;

import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.EnumSet;

public class StringCodec
implements Codec<String> {
    public static final StringCodec INSTANCE = new StringCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BIT, new DataType[]{DataType.OLDDECIMAL, DataType.TINYINT, DataType.SMALLINT, DataType.INT, DataType.FLOAT, DataType.DOUBLE, DataType.TIMESTAMP, DataType.BIGINT, DataType.MEDIUMINT, DataType.DATE, DataType.TIME, DataType.DATETIME, DataType.YEAR, DataType.NEWDATE, DataType.JSON, DataType.DECIMAL, DataType.ENUM, DataType.SET, DataType.VARCHAR, DataType.CHAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.INT8_VECTOR, DataType.INT16_VECTOR, DataType.INT32_VECTOR, DataType.INT64_VECTOR, DataType.FLOAT32_VECTOR, DataType.FLOAT64_VECTOR});

    @Override
    public String className() {
        return String.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(String.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof String;
    }

    @Override
    public int getApproximateTextProtocolLength(Object value) throws SQLException {
        return this.canEncode(value) ? String.valueOf(value).length() * 3 : -1;
    }

    @Override
    public String decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeStringText(buf, length, cal);
    }

    @Override
    public String decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeStringBinary(buf, length, cal);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeByte(39);
        encoder.writeStringEscaped(maxLen == null ? value.toString() : value.toString().substring(0, maxLen.intValue()));
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer writer, Object value, Calendar cal, Long maxLength) throws IOException {
        byte[] b = value.toString().getBytes(StandardCharsets.UTF_8);
        int len = maxLength != null ? Math.min(maxLength.intValue(), b.length) : b.length;
        writer.writeLength(len);
        writer.writeBytes(b, 0, len);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARCHAR.get();
    }
}

