/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential;

import com.singlestore.jdbc.Driver;
import com.singlestore.jdbc.plugin.CredentialPlugin;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class CredentialPluginLoader {
    private static final ServiceLoader<CredentialPlugin> loader = ServiceLoader.load(CredentialPlugin.class, Driver.class.getClassLoader());
    private static final Map<String, CredentialPlugin> loadedPlugins = new ConcurrentHashMap<String, CredentialPlugin>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CredentialPlugin get(String type) throws SQLException {
        if (type == null) {
            return null;
        }
        CredentialPlugin plugin = loadedPlugins.get(type);
        if (plugin != null) {
            return plugin;
        }
        StringWriter errorBuffer = new StringWriter();
        try (PrintWriter errorWriter = new PrintWriter(errorBuffer);){
            ServiceLoader<CredentialPlugin> serviceLoader = loader;
            synchronized (serviceLoader) {
                Iterator<CredentialPlugin> iterator = loader.iterator();
                while (iterator.hasNext()) {
                    try {
                        CredentialPlugin impl = iterator.next();
                        loadedPlugins.putIfAbsent(impl.type(), impl);
                        if (!type.equals(impl.type())) continue;
                        CredentialPlugin credentialPlugin = impl;
                        return credentialPlugin;
                    }
                    catch (ServiceConfigurationError e) {
                        errorWriter.println("Failed to load credential plugin. Ensure all required dependencies for this plugin are available:");
                        e.printStackTrace(errorWriter);
                    }
                }
            }
        }
        String errorMsg = errorBuffer.toString();
        if (errorMsg.length() <= 0) throw new IllegalArgumentException("No identity plugin registered with the type \"" + type + "\".");
        throw new SQLException("No identity plugin registered with the type \"" + type + "\" or the required plugin could not be loaded. Some plugins failed to load:\n" + errorMsg, "08004", 1251);
    }
}

