/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.ParameterMetaData;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.client.result.ResultSetMetaData;
import com.singlestore.jdbc.client.util.ClosableLock;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.message.client.PreparePacket;
import com.singlestore.jdbc.message.client.QueryWithParametersPacket;
import com.singlestore.jdbc.message.client.RewriteQueryMultiPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.util.ClientParser;
import com.singlestore.jdbc.util.ParameterList;
import com.singlestore.jdbc.util.RewriteClientParser;
import com.singlestore.jdbc.util.timeout.QueryTimeoutHandler;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class ClientPreparedStatement
extends BasePreparedStatement {
    private final ClientParser parser;

    public ClientPreparedStatement(String sql, Connection con, ClosableLock lock, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        super(sql, con, lock, false, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        this.parser = ClientParser.parameterParts(sql);
        this.parameters = new ParameterList(this.parser.getParamCount());
    }

    private void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        try (ClosableLock ignore = this.lock.closeableLock();
             QueryTimeoutHandler ignore2 = this.con.handleTimeout(this.queryTimeout);){
            QueryWithParametersPacket query = new QueryWithParametersPacket(null, this.parser, this.parameters, this.localInfileInputStream);
            this.results = this.con.getClient().execute(query, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
        }
    }

    private boolean executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        Configuration conf = this.con.getContext().getConf();
        if (conf.rewriteBatchedStatements() && this.parser.isRewriteBatchedApplicable() && this.autoGeneratedKeys != 1) {
            this.executeBatchWithInsertRewrite();
            return true;
        }
        boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
        if (possibleLoadLocal) {
            String sqlUpper = this.sql.toUpperCase(Locale.ROOT);
            boolean bl = possibleLoadLocal = sqlUpper.contains(" LOCAL ") && sqlUpper.contains("LOAD") && sqlUpper.contains(" INFILE");
        }
        if (possibleLoadLocal) {
            this.executeBatchStd();
        } else {
            this.executeBatchPipeline();
        }
        return false;
    }

    private void executeBatchWithInsertRewrite() throws SQLException {
        try {
            this.results = this.con.getClient().executePipeline(this.getClientMessageForRewriteBatchedStatement(), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private ClientMessage[] getClientMessageForRewriteBatchedStatement() {
        RewriteClientParser rewriteClientParser = RewriteClientParser.rewritableParts(this.parser.getSql());
        return new ClientMessage[]{new RewriteQueryMultiPacket(this.con.getContext().getConf(), rewriteClientParser.getParamCount(), rewriteClientParser, this.batchParameters)};
    }

    private void executeBatchPipeline() throws SQLException {
        ClientMessage[] packets = new ClientMessage[this.batchParameters.size()];
        for (int i = 0; i < this.batchParameters.size(); ++i) {
            packets[i] = new QueryWithParametersPacket(null, this.parser, (Parameters)this.batchParameters.get(i), null);
        }
        try {
            this.results = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private void executeBatchStd() throws SQLException {
        try {
            this.results = new ArrayList();
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                this.results.addAll(this.con.getClient().execute(new QueryWithParametersPacket(null, this.parser, (Parameters)this.batchParameters.get(i), this.localInfileInputStream), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false));
            }
        }
        catch (SQLException bue) {
            BatchUpdateException exception = this.exceptionFactory().createBatchUpdate(this.results, this.batchParameters.size(), bue);
            this.results = null;
            throw exception;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        return this.currResult instanceof Result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        if (Boolean.parseBoolean(this.con.getContext().getConf().nonMappedOptions().getProperty("permitNoResults", "false"))) {
            return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
        }
        throw new SQLException("PrepareStatement.executeQuery() command does NOT return a result-set as expected. Either use PrepareStatement.execute(), PrepareStatement.executeUpdate(), or correct command");
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = this.parameters.clone();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        } else {
            this.batchParameters.clear();
        }
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parser.getParamCount(); ++i) {
            if (this.parameters.containsKey(i)) continue;
            throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    /*
     * Exception decompiling
     */
    @Override
    public int[] executeBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int[] getUpdateCounts(boolean rewrite) {
        int[] result;
        if (rewrite) {
            result = new int[this.batchParameters.size()];
            int resultValue = -2;
            if (this.results.get(0) instanceof OkPacket) {
                int affectedRows = (int)((OkPacket)this.results.get(0)).getAffectedRows();
                if (this.batchParameters.size() == 1 || affectedRows == 0) {
                    resultValue = affectedRows;
                }
            }
            Arrays.fill(result, resultValue);
        } else {
            result = new int[this.results.size()];
            for (int i = 0; i < this.results.size(); ++i) {
                result[i] = this.results.get(i) instanceof OkPacket ? (int)((OkPacket)this.results.get(i)).getAffectedRows() : -2;
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long[] getLargeUpdateCounts(boolean rewrite) {
        long[] result;
        if (rewrite) {
            result = new long[this.batchParameters.size()];
            long resultValue = -2L;
            if (this.results.get(0) instanceof OkPacket) {
                long affectedRows = ((OkPacket)this.results.get(0)).getAffectedRows();
                if (this.batchParameters.size() == 1 || affectedRows == 0L) {
                    resultValue = affectedRows;
                }
            }
            Arrays.fill(result, resultValue);
        } else {
            result = new long[this.results.size()];
            for (int i = 0; i < this.results.size(); ++i) {
                result[i] = this.results.get(i) instanceof OkPacket ? ((OkPacket)this.results.get(i)).getAffectedRows() : -2L;
            }
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            try (ClosableLock ignore = this.lock.closeableLock();){
                this.prepareResult.close(this.con.getClient());
            }
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    @Override
    public String toString() {
        return "ClientPreparedStatement{" + super.toString() + '}';
    }
}

