/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.column;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.plugin.codec.LocalDateTimeCodec;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public class TimestampColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public TimestampColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected TimestampColumn(TimestampColumn prev) {
        super(prev, true);
    }

    @Override
    public TimestampColumn useAliasAsName() {
        return new TimestampColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Timestamp.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 93;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return this.dataType.name();
    }

    @Override
    public int getPrecision() {
        return this.getDisplaySize();
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeTimestampText(buf, length, null);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeTimestampBinary(buf, length, null);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (length.get() == 0) {
            StringBuilder zeroValue = new StringBuilder("0000-00-00 00:00:00");
            if (this.getDecimals() > 0) {
                zeroValue.append(".");
                for (int i = 0; i < this.getDecimals(); ++i) {
                    zeroValue.append("0");
                }
            }
            return zeroValue.toString();
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte day = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && day == 0) {
            return "0000-00-00 00:00:00";
        }
        LocalDateTime dateTime = LocalDateTime.of(year, month, (int)day, (int)hour, (int)minutes, (int)seconds).plusNanos(microseconds * 1000L);
        StringBuilder microSecPattern = new StringBuilder();
        if (this.getDecimals() > 0 || microseconds > 0L) {
            int decimal = this.getDecimals() & 0xFF;
            if (decimal == 0) {
                decimal = 6;
            }
            microSecPattern.append(".");
            for (int i = 0; i < decimal; ++i) {
                microSecPattern.append("S");
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss" + microSecPattern);
        return dateTime.toLocalDate().toString() + ' ' + dateTime.toLocalTime().format(formatter);
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Date(TimestampColumn.localDateTimeToInstant(ldt, cal) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Date(TimestampColumn.localDateTimeToInstant(ldt, calParam) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Time(TimestampColumn.localDateTimeToInstant(ldt.withYear(1970).withMonth(1).withDayOfMonth(1), cal) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        return new Time(TimestampColumn.localDateTimeToInstant(ldt.withYear(1970).withMonth(1).withDayOfMonth(1), calParam) + (long)(ldt.getNano() / 1000000));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        LocalDateTime ldt = this.parseText(buf, length);
        if (ldt == null) {
            return null;
        }
        Timestamp res = new Timestamp(TimestampColumn.localDateTimeToInstant(ldt, calParam));
        res.setNanos(ldt.getNano());
        return res;
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        LocalDateTime ldt = this.parseBinary(buf, length);
        if (ldt == null) {
            return null;
        }
        Timestamp res = new Timestamp(TimestampColumn.localDateTimeToInstant(ldt, calParam));
        res.setNanos(ldt.getNano());
        return res;
    }

    private LocalDateTime parseText(ReadableByteBuf buf, MutableInt length) {
        int[] parts = LocalDateTimeCodec.parseTimestamp(buf.readAscii(length.get()));
        if (parts == null) {
            length.set(-1);
            return null;
        }
        return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]);
    }

    private LocalDateTime parseBinary(ReadableByteBuf buf, MutableInt length) {
        if (length.get() == 0) {
            length.set(-1);
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0 && microseconds == 0L) {
            length.set(-1);
            return null;
        }
        return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minutes, (int)seconds).plusNanos(microseconds * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long localDateTimeToInstant(LocalDateTime ldt, Calendar calParam) {
        if (calParam == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
            cal.set(14, 0);
            return cal.getTimeInMillis();
        }
        Calendar calendar = calParam;
        synchronized (calendar) {
            calParam.clear();
            calParam.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
            return calParam.getTimeInMillis();
        }
    }
}

