/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.impl.StandardReadableByteBuf;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.StreamingResult;
import com.singlestore.jdbc.client.result.UpdatableResult;
import com.singlestore.jdbc.client.socket.Reader;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.client.util.ClosableLock;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.message.server.ErrorPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.regex.Pattern;

public interface ClientMessage {
    public static boolean validateLocalFileName(String sql, Parameters parameters, String fileName, Context context) {
        String reg = "LOAD\\s+(DATA\\s+)?LOCAL\\s+INFILE\\s+'" + Pattern.quote(fileName.replace("\\", "\\\\")) + "'";
        Pattern pattern = Pattern.compile(reg, 2);
        if (pattern.matcher(sql).find()) {
            return true;
        }
        if (parameters != null && (pattern = Pattern.compile("LOAD\\s+(DATA\\s+)?LOCAL\\s+INFILE\\s+\\?", 2)).matcher(sql).find() && parameters.size() > 0) {
            String paramString = parameters.get(0).bestEffortStringValue(context);
            if (paramString != null) {
                return paramString.equalsIgnoreCase("'" + fileName.replace("\\", "\\\\") + "'");
            }
            return true;
        }
        return false;
    }

    public int encode(Writer var1, Context var2) throws IOException, SQLException;

    default public int batchUpdateLength() {
        return 0;
    }

    default public String description() {
        return null;
    }

    default public boolean binaryProtocol() {
        return false;
    }

    default public boolean canSkipMeta() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ClosableLock lock, boolean traceEnable, ClientMessage message) throws IOException, SQLException {
        ColumnDecoder[] ci;
        ReadableByteBuf buf = reader.readReusablePacket(traceEnable);
        switch (buf.getByte()) {
            case 0: {
                return new OkPacket(buf, context);
            }
            case -1: {
                ErrorPacket errorPacket = new ErrorPacket(buf, context);
                throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            case -5: {
                buf.skip(1);
                SQLException exception = null;
                reader.getSequence().set(writer.getSequence());
                InputStream is = this.getLocalInfileInputStream();
                if (is == null) {
                    String fileName = buf.readStringNullEnd();
                    if (!message.validateLocalFileName(fileName, context)) {
                        exception = exceptionFactory.withSql(this.description()).create(String.format("LOAD DATA LOCAL INFILE asked for file '%s' that doesn't correspond to initial query %s. Possible malicious proxy changing server answer ! Command interrupted", fileName, this.description()), "HY000");
                    } else {
                        try {
                            is = new FileInputStream(fileName);
                        }
                        catch (FileNotFoundException f) {
                            exception = exceptionFactory.withSql(this.description()).create("Could not send file : " + f.getMessage(), "HY000", f);
                        }
                    }
                }
                if (is != null) {
                    try {
                        int len;
                        byte[] fileBuf = new byte[8192];
                        while ((len = is.read(fileBuf)) > 0) {
                            writer.writeBytes(fileBuf, 0, len);
                            writer.flush();
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                writer.writeEmptyPacket();
                Completion completion = this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable, message);
                if (exception != null) {
                    throw exception;
                }
                return completion;
            }
        }
        int fieldCount = buf.readIntLengthEncodedNotNull();
        if (context.canSkipMeta() && this.canSkipMeta()) {
            if (buf.readByte() == 0) {
                ci = ((BasePreparedStatement)stmt).getMeta();
            } else {
                ci = new ColumnDecoder[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    ci[i] = context.getColumnDecoderFunction().apply(new StandardReadableByteBuf(reader.readPacket(traceEnable)));
                }
                ((BasePreparedStatement)stmt).updateMeta(ci);
            }
        } else {
            ci = new ColumnDecoder[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                ci[i] = context.getColumnDecoderFunction().apply(new StandardReadableByteBuf(reader.readPacket(traceEnable)));
            }
        }
        if (!context.isEofDeprecated()) {
            reader.skipPacket();
        }
        if (resultSetConcurrency == 1008) {
            return new UpdatableResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
        }
        if (fetchSize != 0) {
            if ((context.getServerStatus() & 8) > 0) {
                context.setServerStatus(context.getServerStatus() - 8);
            }
            return new StreamingResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, fetchSize, lock, resultSetType, closeOnCompletion, traceEnable);
        }
        return new CompleteResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
    }

    default public InputStream getLocalInfileInputStream() {
        return null;
    }

    default public boolean validateLocalFileName(String fileName, Context context) {
        return false;
    }
}

