/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.authentication.addon;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.impl.StandardReadableByteBuf;
import com.singlestore.jdbc.client.socket.Reader;
import com.singlestore.jdbc.client.socket.Writer;
import com.singlestore.jdbc.plugin.AuthenticationPlugin;
import com.singlestore.jdbc.plugin.authentication.addon.gssapi.GssUtility;
import com.singlestore.jdbc.plugin.authentication.addon.gssapi.GssapiAuth;
import com.singlestore.jdbc.plugin.authentication.addon.gssapi.StandardGssapiAuthentication;
import java.io.IOException;
import java.sql.SQLException;

public class SendGssApiAuthPacket
implements AuthenticationPlugin {
    private static final GssapiAuth gssapiAuth;
    private byte[] seed;
    private String optionServicePrincipalName;
    private String optionJaasApplicationName;

    public SendGssApiAuthPacket(byte[] seed, Configuration conf) {
        this.seed = seed;
        this.optionServicePrincipalName = conf.servicePrincipalName();
        this.optionJaasApplicationName = conf.jaasApplicationName();
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context) throws IOException, SQLException {
        StandardReadableByteBuf buf = new StandardReadableByteBuf(this.seed, this.seed.length);
        String serverSpn = buf.readStringNullEnd();
        String servicePrincipalName = this.optionServicePrincipalName != null ? this.optionServicePrincipalName : serverSpn;
        String jaasApplicationName = this.optionJaasApplicationName != null ? this.optionJaasApplicationName : "";
        String mechanisms = buf.readStringNullEnd();
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        gssapiAuth.authenticate(context, out, in, servicePrincipalName, jaasApplicationName, mechanisms);
        return in.readReusablePacket();
    }

    static {
        GssapiAuth init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t) {
            init = new StandardGssapiAuthentication();
        }
        gssapiAuth = init;
    }
}

