/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.type;

import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.util.VectorDataUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class Vector {
    private final byte[] values;
    private final int length;
    private final DataType type;
    private final boolean isBinary;

    private Vector(byte[] values, int length, DataType type, boolean isBinary) {
        this.values = values;
        this.length = length;
        this.type = type;
        this.isBinary = isBinary;
    }

    public static Vector fromData(byte[] values, int length, DataType dataType, boolean isBinary) {
        return new Vector(values, length, dataType, isBinary);
    }

    public static Vector ofFloat64Values(double[] values) {
        String data = Arrays.toString(values).replace(" ", "");
        return Vector.fromData(data.getBytes(StandardCharsets.UTF_8), values.length, DataType.FLOAT64_VECTOR, false);
    }

    public static Vector ofFloat32Values(float[] values) {
        String data = Arrays.toString(values).replace(" ", "");
        return Vector.fromData(data.getBytes(StandardCharsets.UTF_8), values.length, DataType.FLOAT32_VECTOR, false);
    }

    public static Vector ofInt8Values(byte[] values) {
        String data = Arrays.toString(values).replace(" ", "");
        return Vector.fromData(data.getBytes(StandardCharsets.UTF_8), values.length, DataType.INT8_VECTOR, false);
    }

    public static Vector ofInt16Values(short[] values) {
        String data = Arrays.toString(values).replace(" ", "");
        return Vector.fromData(data.getBytes(StandardCharsets.UTF_8), values.length, DataType.INT16_VECTOR, false);
    }

    public static Vector ofInt32Values(int[] values) {
        String data = Arrays.toString(values).replace(" ", "");
        return Vector.fromData(data.getBytes(StandardCharsets.UTF_8), values.length, DataType.INT32_VECTOR, false);
    }

    public static Vector ofInt64Values(long[] values) {
        String data = Arrays.toString(values).replace(" ", "");
        return Vector.fromData(data.getBytes(StandardCharsets.UTF_8), values.length, DataType.INT64_VECTOR, false);
    }

    public byte[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public DataType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public String stringValue() {
        return Arrays.toString(this.toStringArray()).replace(", ", ",");
    }

    public String[] toStringArray() {
        return this.isBinary() ? VectorDataUtils.parseBinary(this.values, this.length, String[].class, this.type) : VectorDataUtils.parse(this.values, this.length, String[].class, this.type);
    }

    public float[] toFloatArray() {
        return this.isBinary() ? VectorDataUtils.parseBinary(this.values, this.length, float[].class, this.type) : VectorDataUtils.parse(this.values, this.length, float[].class, this.type);
    }

    public double[] toDoubleArray() {
        return this.isBinary() ? VectorDataUtils.parseBinary(this.values, this.length, double[].class, this.type) : VectorDataUtils.parse(this.values, this.length, double[].class, this.type);
    }

    public byte[] toByteArray() {
        return this.isBinary() ? VectorDataUtils.parseBinary(this.values, this.length, byte[].class, this.type) : VectorDataUtils.parse(this.values, this.length, byte[].class, this.type);
    }

    public short[] toShortArray() {
        return this.isBinary() ? VectorDataUtils.parseBinary(this.values, this.length, short[].class, this.type) : VectorDataUtils.parse(this.values, this.length, short[].class, this.type);
    }

    public int[] toIntArray() {
        return this.isBinary() ? VectorDataUtils.parseBinary(this.values, this.length, int[].class, this.type) : VectorDataUtils.parse(this.values, this.length, int[].class, this.type);
    }

    public long[] toLongArray() {
        return this.isBinary() ? VectorDataUtils.parseBinary(this.values, this.length, long[].class, this.type) : VectorDataUtils.parse(this.values, this.length, long[].class, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector vector = (Vector)o;
        return this.length == vector.length && this.isBinary == vector.isBinary && Objects.deepEquals(this.values, vector.values) && this.type == vector.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.values), this.length, this.type, this.isBinary});
    }

    public String toString() {
        return "Vector{values=" + this.stringValue() + ", length=" + this.length + ", type=" + (Object)((Object)this.type) + ", isBinary=" + this.isBinary + '}';
    }
}

