/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util;

import com.singlestore.jdbc.util.ClientParser;
import com.singlestore.jdbc.util.PrepareResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class RewriteClientParser
implements PrepareResult {
    private final String sql;
    private final List<byte[]> queryParts;
    private final int paramCount;
    private final int queryPartsLength;
    private final int paramPartsLength;
    private final boolean isQueryMultiValuesRewritable;

    private RewriteClientParser(String sql, List<byte[]> queryParts, int queryPartsLength, int paramPartsLength, boolean isQueryMultiValuesRewritable) {
        this.sql = sql;
        this.queryParts = queryParts;
        this.queryPartsLength = queryPartsLength;
        this.paramPartsLength = paramPartsLength;
        this.isQueryMultiValuesRewritable = isQueryMultiValuesRewritable;
        this.paramCount = queryParts.size() - 3;
    }

    public static RewriteClientParser rewritableParts(String queryString) {
        boolean reWritablePrepare = true;
        ArrayList<byte[]> partList = new ArrayList<byte[]>();
        ClientParser.LexState state = ClientParser.LexState.Normal;
        char lastChar = '\u0000';
        StringBuilder sb = new StringBuilder();
        String preValuePart1 = null;
        String preValuePart2 = null;
        String postValuePart = null;
        boolean singleQuotes = false;
        int isInParenthesis = 0;
        boolean skipChar = false;
        boolean isFirstChar = true;
        boolean isInsert = false;
        boolean isReplace = false;
        boolean semicolon = false;
        boolean hasParam = false;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (!(state != ClientParser.LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                sb.append(car);
                lastChar = car;
                state = ClientParser.LexState.String;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != ClientParser.LexState.Normal || lastChar != '/') break;
                    state = ClientParser.LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state != ClientParser.LexState.SlashStarComment || lastChar != '*') break;
                    state = ClientParser.LexState.Normal;
                    break;
                }
                case '#': {
                    if (state != ClientParser.LexState.Normal) break;
                    state = ClientParser.LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != ClientParser.LexState.Normal || lastChar != '-') break;
                    state = ClientParser.LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != ClientParser.LexState.EOLComment) break;
                    state = ClientParser.LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == ClientParser.LexState.Normal) {
                        state = ClientParser.LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == ClientParser.LexState.String && !singleQuotes) {
                        state = ClientParser.LexState.Normal;
                        break;
                    }
                    if (state != ClientParser.LexState.Escape || singleQuotes) break;
                    state = ClientParser.LexState.String;
                    break;
                }
                case ';': {
                    if (state != ClientParser.LexState.Normal) break;
                    semicolon = true;
                    break;
                }
                case '\'': {
                    if (state == ClientParser.LexState.Normal) {
                        state = ClientParser.LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == ClientParser.LexState.String && singleQuotes) {
                        state = ClientParser.LexState.Normal;
                        break;
                    }
                    if (state != ClientParser.LexState.Escape || !singleQuotes) break;
                    state = ClientParser.LexState.String;
                    break;
                }
                case '\\': {
                    if (state != ClientParser.LexState.String) break;
                    state = ClientParser.LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != ClientParser.LexState.Normal) break;
                    hasParam = true;
                    if (preValuePart1 == null) {
                        preValuePart1 = sb.toString();
                        sb.setLength(0);
                    }
                    if (preValuePart2 == null) {
                        preValuePart2 = sb.toString();
                        sb.setLength(0);
                    } else {
                        if (postValuePart != null) {
                            reWritablePrepare = false;
                            sb.insert(0, postValuePart);
                            postValuePart = null;
                        }
                        partList.add(sb.toString().getBytes(StandardCharsets.UTF_8));
                        sb.setLength(0);
                    }
                    skipChar = true;
                    break;
                }
                case '`': {
                    if (state == ClientParser.LexState.Backtick) {
                        state = ClientParser.LexState.Normal;
                        break;
                    }
                    if (state != ClientParser.LexState.Normal) break;
                    state = ClientParser.LexState.Backtick;
                    break;
                }
                case 'S': 
                case 's': {
                    if (state != ClientParser.LexState.Normal || postValuePart != null || queryLength <= i + 7 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'c' && query[i + 4] != 'C' || query[i + 5] != 't' && query[i + 5] != 'T' || i > 0 && query[i - 1] > ' ' && "();><=-+,".indexOf(query[i - 1]) == -1 || query[i + 6] > ' ' && "();><=-+,".indexOf(query[i + 6]) == -1) break;
                    reWritablePrepare = false;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (state != ClientParser.LexState.Normal || preValuePart1 != null || lastChar != ')' && (byte)lastChar > 40 || queryLength <= i + 7 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'e' && query[i + 4] != 'E' || query[i + 5] != 's' && query[i + 5] != 'S' || query[i + 6] != '(' && (byte)query[i + 6] > 40) break;
                    sb.append(car);
                    sb.append(query[i + 1]);
                    sb.append(query[i + 2]);
                    sb.append(query[i + 3]);
                    sb.append(query[i + 4]);
                    sb.append(query[i + 5]);
                    i += 5;
                    preValuePart1 = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                case 'L': 
                case 'l': {
                    if (state != ClientParser.LexState.Normal || queryLength <= i + 14 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 's' && query[i + 2] != 'S' || query[i + 3] != 't' && query[i + 3] != 'T' || query[i + 4] != '_' || query[i + 5] != 'i' && query[i + 5] != 'I' || query[i + 6] != 'n' && query[i + 6] != 'N' || query[i + 7] != 's' && query[i + 7] != 'S' || query[i + 8] != 'e' && query[i + 8] != 'E' || query[i + 9] != 'r' && query[i + 9] != 'R' || query[i + 10] != 't' && query[i + 10] != 'T' || query[i + 11] != '_' || query[i + 12] != 'i' && query[i + 12] != 'I' || query[i + 13] != 'd' && query[i + 13] != 'D' || query[i + 14] != '(') break;
                    sb.append(car);
                    reWritablePrepare = false;
                    skipChar = true;
                    break;
                }
                case '(': {
                    if (state != ClientParser.LexState.Normal) break;
                    ++isInParenthesis;
                    break;
                }
                case ')': {
                    if (state != ClientParser.LexState.Normal || --isInParenthesis != 0 || preValuePart2 == null || postValuePart != null) break;
                    sb.append(car);
                    postValuePart = sb.toString();
                    sb.setLength(0);
                    skipChar = true;
                    break;
                }
                default: {
                    if (state == ClientParser.LexState.Normal && isFirstChar && (byte)car >= 40) {
                        if (car == 'I' || car == 'i') {
                            isInsert = true;
                        } else if (car == 'R' || car == 'r') {
                            isReplace = true;
                        }
                        isFirstChar = false;
                    }
                    if (state != ClientParser.LexState.Normal || !semicolon || (byte)car < 40) break;
                    reWritablePrepare = false;
                }
            }
            lastChar = car;
            if (skipChar) {
                skipChar = false;
                continue;
            }
            sb.append(car);
        }
        if (!hasParam) {
            if (preValuePart1 == null) {
                partList.add(0, sb.toString().getBytes(StandardCharsets.UTF_8));
                partList.add(1, new byte[0]);
            } else {
                partList.add(0, preValuePart1.getBytes(StandardCharsets.UTF_8));
                partList.add(1, sb.toString().getBytes(StandardCharsets.UTF_8));
            }
            sb.setLength(0);
        } else {
            partList.add(0, preValuePart1 == null ? new byte[]{} : preValuePart1.getBytes(StandardCharsets.UTF_8));
            partList.add(1, preValuePart2 == null ? new byte[]{} : preValuePart2.getBytes(StandardCharsets.UTF_8));
        }
        if (!isInsert && !isReplace) {
            reWritablePrepare = false;
        }
        if (hasParam) {
            partList.add(postValuePart == null ? new byte[]{} : postValuePart.getBytes(StandardCharsets.UTF_8));
        }
        partList.add(sb.toString().getBytes(StandardCharsets.UTF_8));
        int queryPartsLength = 1;
        int paramPartsLength = 1;
        for (int i = 0; i < partList.size(); ++i) {
            byte[] queryPart = (byte[])partList.get(i);
            queryPartsLength += queryPart.length;
            if (i <= 0 || i >= partList.size() - 1) continue;
            paramPartsLength += queryPart.length;
        }
        return new RewriteClientParser(queryString, partList, queryPartsLength, paramPartsLength, reWritablePrepare);
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public List<byte[]> getQueryParts() {
        return this.queryParts;
    }

    public boolean isQueryMultiValuesRewritable() {
        return this.isQueryMultiValuesRewritable;
    }

    public int getQueryPartsLength() {
        return this.queryPartsLength;
    }

    public int getParamPartsLength() {
        return this.paramPartsLength;
    }
}

