/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util.timeout;

import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.client.util.ClosableLock;
import com.singlestore.jdbc.client.util.SchedulerProvider;
import com.singlestore.jdbc.util.log.Loggers;
import com.singlestore.jdbc.util.timeout.QueryTimeoutHandler;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class QueryTimeoutHandlerImpl
implements QueryTimeoutHandler {
    private Future<?> timerTaskFuture;
    private ScheduledExecutorService timeoutScheduler;
    private Connection conn;
    private ClosableLock lock;

    @Override
    public QueryTimeoutHandler create(int queryTimeout) {
        assert (this.timerTaskFuture == null);
        if (queryTimeout > 0) {
            if (this.timeoutScheduler == null) {
                this.timeoutScheduler = SchedulerProvider.getTimeoutScheduler(this.lock);
            }
            this.timerTaskFuture = this.timeoutScheduler.schedule(() -> {
                try {
                    this.conn.cancelCurrentQuery();
                }
                catch (Throwable e) {
                    Loggers.getLogger(QueryTimeoutHandlerImpl.class.getName()).error(e.getMessage(), e);
                }
            }, (long)queryTimeout, TimeUnit.SECONDS);
        }
        return this;
    }

    public QueryTimeoutHandlerImpl(Connection conn, ClosableLock lock) {
        this.conn = conn;
        this.lock = lock;
    }

    @Override
    public void close() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }
}

