/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util.vector;

import com.singlestore.jdbc.client.util.VectorType;
import com.singlestore.jdbc.util.vector.VectorParser;

public class Float32VectorParser
extends VectorParser<float[]> {
    public static final Float32VectorParser INSTANCE = new Float32VectorParser();

    protected Float32VectorParser() {
        super(VectorType.F32);
    }

    @Override
    public float[] parseDefault(byte[] data, int length) {
        String[] values = Float32VectorParser.parseVectorString(data, length);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            try {
                floats[i] = Float.parseFloat(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid F32 number format at index " + i + ": " + values[i]);
            }
        }
        return floats;
    }

    @Override
    float[] parseFloats(byte[] data, int length) {
        return this.parseDefault(data, length);
    }

    @Override
    double[] parseDoubles(byte[] data, int length) {
        float[] floats = this.parseDefault(data, length);
        double[] doubles = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            doubles[i] = floats[i];
        }
        return doubles;
    }
}

