/*
 * Decompiled with CFR 0.152.
 */
package com.sipgate.mp3wav;

import com.sipgate.mp3wav.ConversionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public final class Converter {
    private InputStream input;
    private AudioFormat audioFormat;
    private boolean close;

    public Converter(InputStream input) {
        this(input, false);
    }

    public Converter(InputStream input, boolean close) {
        this.input = input;
        this.close = close;
    }

    public static Converter convertFrom(InputStream input) {
        return new Converter(input, false);
    }

    public static Converter convertFrom(byte[] mp3Content) {
        return new Converter(new ByteArrayInputStream(mp3Content), true);
    }

    public Converter withTargetFormat(AudioFormat targetAudioFormat) {
        this.audioFormat = targetAudioFormat;
        return this;
    }

    public void to(OutputStream output) {
        try (ByteArrayOutputStream rawOutputStream = new ByteArrayOutputStream();){
            this.convert(this.input, rawOutputStream, this.getTargetFormat());
            byte[] rawResult = rawOutputStream.toByteArray();
            AudioInputStream audioInputStream = new AudioInputStream(new ByteArrayInputStream(rawResult), this.getTargetFormat(), rawResult.length);
            AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, output);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
        finally {
            this.closeInput();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toByteArray() {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.to(output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    private void closeInput() {
        if (this.close) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void convert(InputStream input, OutputStream output, AudioFormat targetFormat) throws Exception {
        try (AudioInputStream rawSourceStream = AudioSystem.getAudioInputStream(input);){
            AudioFormat sourceFormat = rawSourceStream.getFormat();
            AudioFormat convertFormat = this.getAudioFormat(sourceFormat);
            try (AudioInputStream sourceStream = AudioSystem.getAudioInputStream(convertFormat, rawSourceStream);
                 AudioInputStream convertStream = AudioSystem.getAudioInputStream(targetFormat, sourceStream);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = convertStream.read(buffer, 0, buffer.length)) >= 0) {
                    output.write(buffer, 0, read);
                }
            }
        }
    }

    private AudioFormat getTargetFormat() {
        return this.audioFormat == null ? new AudioFormat(44100.0f, 8, 1, true, false) : this.audioFormat;
    }

    private AudioFormat getAudioFormat(AudioFormat sourceFormat) {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), false);
    }
}

